/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.task;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.util.IconUtils;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneBuilder;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.task.TaskPaneWorker;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;

public final class TaskPaneBuilder
extends AbstractStyledPaneBuilder<TaskPane, TaskPaneBuilder> {
    private Dimension expansionWindowSizeOffset = null;

    public TaskPaneBuilder() {
        super(null);
    }

    public TaskPaneBuilder(TaskPane pane) {
        super(pane);
    }

    @Override
    public TaskPaneBuilder messageType(MessageType messageType) {
        return (TaskPaneBuilder)super.messageType(messageType);
    }

    public TaskPaneBuilder mainInstructionIcon(Icon icon) {
        ((TaskPane)this.pane).setMainInstructionIcon(icon);
        return this;
    }

    public TaskPaneBuilder mainInstructionIcon(Icon icon, Insets cropInsets) {
        ((TaskPane)this.pane).setMainInstructionIcon(IconUtils.crop(icon, cropInsets));
        return this;
    }

    public TaskPaneBuilder mainInstructionIconVerticalAlignment(TaskPaneVisualConfiguration.MainInstructionIconVerticalAlignment alignment) {
        ((TaskPaneVisualConfiguration)((TaskPane)this.pane).getVisualConfiguration()).setMainInstructionIconVerticalAlignment(alignment);
        return this;
    }

    public TaskPaneBuilder mainInstructionText(String mayBeMarkedText, Object ... args) {
        ((TaskPane)this.pane).setMainInstructionText(Strings.get(mayBeMarkedText, args));
        return this;
    }

    public TaskPaneBuilder mainInstructionLabelsContent(boolean b) {
        ((TaskPane)this.pane).setMainInstructionLabelsContent(b);
        return this;
    }

    public TaskPaneBuilder content(JComponent c) {
        ((TaskPane)this.pane).setContent(c);
        return this;
    }

    public TaskPaneBuilder contentText(String text, Object ... args) {
        ((TaskPane)this.pane).setContentText(Strings.get(text, args));
        return this;
    }

    public TaskPaneBuilder expandedText(String text, Object ... args) {
        ((TaskPane)this.pane).setExpandedText(Strings.get(text, args));
        return this;
    }

    public TaskPaneBuilder progressVisible(boolean b) {
        ((TaskPane)this.pane).setProgressVisible(b);
        return this;
    }

    public TaskPaneBuilder progressIndeterminate(boolean b) {
        ((TaskPane)this.pane).setProgressIndeterminate(b);
        return this;
    }

    public TaskPaneBuilder addRadioButton(Object choice, String markedText) {
        ((TaskPane)this.pane).addRadioButton(choice, markedText);
        return this;
    }

    public TaskPaneBuilder radioValue(Object value) {
        ((TaskPane)this.pane).setRadioValue(value);
        return this;
    }

    public TaskPaneBuilder addCommandLink(Object value, String markedText) {
        ((TaskPane)this.pane).addCommandLink(value, markedText, null);
        return this;
    }

    public TaskPaneBuilder addCommandLink(Object value, String markedText, String description) {
        ((TaskPane)this.pane).addCommandLink(value, markedText, description);
        return this;
    }

    public TaskPaneBuilder addCommandLink(CommandValue value, String description) {
        ((TaskPane)this.pane).addCommandLink(value, description);
        return this;
    }

    public TaskPaneBuilder addCommandLink(Action action, boolean forceStandardIcon) {
        ((TaskPane)this.pane).addCommandLink(action, forceStandardIcon);
        return this;
    }

    public TaskPaneBuilder collapsedControlText(String markedText, Object ... args) {
        ((TaskPane)this.pane).setCollapsedControlText(Strings.get(markedText, args));
        return this;
    }

    public TaskPaneBuilder expandedControlText(String markedText, Object ... args) {
        ((TaskPane)this.pane).setExpandedControlText(Strings.get(markedText, args));
        return this;
    }

    public TaskPaneBuilder collapse() {
        this.expanded(false);
        return this;
    }

    public TaskPaneBuilder expand() {
        this.expanded(true);
        return this;
    }

    public TaskPaneBuilder expanded(boolean expanded) {
        ((TaskPane)this.pane).setExpanded(expanded);
        return this;
    }

    public TaskPaneBuilder onExpandedChangeWindowSizeBy(Dimension offset) {
        this.support.checkNotCalledTwice("onExpandedChangeWindowSizeBy");
        this.expansionWindowSizeOffset = offset;
        return this;
    }

    public TaskPaneBuilder onExpandedChangeWindowSizeBy(int widthOffset, int heightOffset) {
        return this.onExpandedChangeWindowSizeBy(new Dimension(widthOffset, heightOffset));
    }

    public TaskPaneBuilder verificationText(String markedText, Object ... args) {
        ((TaskPane)this.pane).setVerificationText(Strings.get(markedText, args));
        return this;
    }

    public TaskPaneBuilder verificationSelected(boolean b) {
        ((TaskPane)this.pane).setVerificationSelected(b);
        return this;
    }

    public TaskPaneBuilder verification(Verification verification) {
        ((TaskPane)this.pane).setVerification(verification);
        return this;
    }

    public TaskPaneBuilder additionalCommands(Action ... actions) {
        ((TaskPane)this.pane).setAdditionalCommands(actions);
        return this;
    }

    public TaskPaneBuilder additionalCommands(List<Action> actions) {
        ((TaskPane)this.pane).setAdditionalCommands(actions.toArray(new Action[actions.size()]));
        return this;
    }

    public TaskPaneBuilder additionalCommandButtons(JButton ... buttons) {
        ((TaskPane)this.pane).setAdditionalCommandButtons(buttons);
        return this;
    }

    @Override
    public TaskPaneBuilder commitCommands(Object ... commitCommands) {
        return (TaskPaneBuilder)super.commitCommands(commitCommands);
    }

    @Override
    public TaskPaneBuilder commitCommands(List<Object> commitCommands) {
        return (TaskPaneBuilder)super.commitCommands(commitCommands);
    }

    @Override
    public TaskPaneBuilder defaultCommand(Object defaultCommand) {
        return (TaskPaneBuilder)super.defaultCommand(defaultCommand);
    }

    @Override
    public TaskPaneBuilder cancelCommand(Object cancelCommand) {
        return (TaskPaneBuilder)super.cancelCommand(cancelCommand);
    }

    @Override
    public TaskPaneBuilder cancelAllowed(boolean b) {
        return (TaskPaneBuilder)super.cancelAllowed(b);
    }

    @Override
    public TaskPaneBuilder commandContentVisible(boolean b) {
        return (TaskPaneBuilder)super.commandContentVisible(b);
    }

    public TaskPaneBuilder marginContentTop(int dlu) {
        ((TaskPaneVisualConfiguration)((TaskPane)this.pane).getVisualConfiguration()).setMarginContentTop(dlu);
        return this;
    }

    public TaskPaneBuilder marginContentBottom(int dlu) {
        ((TaskPaneVisualConfiguration)((TaskPane)this.pane).getVisualConfiguration()).setMarginContentBottom(dlu);
        return this;
    }

    public TaskPane build() {
        return (TaskPane)this.pane;
    }

    public TaskPane showDialogAndExecute(TaskPaneWorker<?, ?> worker) {
        worker.setTaskPane((TaskPane)this.pane);
        worker.execute();
        return (TaskPane)this.showDialog();
    }

    @Override
    protected TaskPane createPane() {
        TaskPane pane = new TaskPane();
        pane.setMainInstructionText(null);
        pane.setContentText(null);
        return pane;
    }

    @Override
    protected JDialog createDialog(TaskPane pane) {
        JDialog dialog = super.createDialog(pane);
        if (pane.isExpanded()) {
            TaskPaneBuilder.changeWindowSize(pane, this.expansionWindowSizeOffset);
        }
        pane.addPropertyChangeListener("expanded", evt -> TaskPaneBuilder.changeWindowSize((TaskPane)evt.getSource(), this.expansionWindowSizeOffset));
        return dialog;
    }

    private static void changeWindowSize(TaskPane aPane, Dimension sizeOffset) {
        Window window = AncestorSupport.getWindowFor(aPane);
        Dimension oldWindowSize = window.getSize();
        int sign = aPane.isExpanded() ? 1 : -1;
        int widthIncrement = sizeOffset.width * sign;
        int heighIncrement = sizeOffset.height * sign;
        window.setSize(new Dimension(oldWindowSize.width + widthIncrement, oldWindowSize.height + heighIncrement));
    }
}

