/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.internal.TextFieldIcons;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class JGSplitButton
extends JGButton {
    static final int POPUP_AREA_WIDTH = ScreenScaling.toPhysical(19);
    private final Icon popupIcon;
    private MouseListener mousePressedListener;
    private MouseListener mouseReleasedListener;
    private JPopupMenu menu;
    private boolean mousePressedInPopupArea = false;

    public JGSplitButton(Action action, JPopupMenu menu) {
        super(action);
        this.setMenu(menu);
        this.popupIcon = this.getPopupIcon();
        this.initEventHandling();
    }

    public JGSplitButton(Icon icon, JPopupMenu menu) {
        this(null, icon, menu);
    }

    public JGSplitButton(String text, JPopupMenu menu) {
        this(text, null, menu);
    }

    public JGSplitButton(String text, Icon icon, JPopupMenu menu) {
        super(text, icon);
        this.setMenu(menu);
        this.popupIcon = this.getPopupIcon();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.mousePressedListener = Listeners.mousePressed(this::onMousePressed);
        this.mouseReleasedListener = Listeners.mouseReleased(this::onMouseReleased);
        this.addKeyListener(Listeners.keyPressed(this::onKeyPressed));
        this.addMouseListener(this.mousePressedListener);
        this.addMouseListener(this.mouseReleasedListener);
    }

    public final JPopupMenu getMenu() {
        return this.menu;
    }

    public final void setMenu(JPopupMenu popupMenu) {
        this.menu = Preconditions.checkNotNull(popupMenu, "The %s must not be null.", "popup menu");
    }

    private void onMousePressed(MouseEvent evt) {
        this.mousePressedInPopupArea = evt.getX() > this.getPopupAreaX();
    }

    private void onMouseReleased(MouseEvent evt) {
        this.mousePressedInPopupArea = false;
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 40 && evt.isAltDown()) {
            evt.consume();
            JGSplitButton.showMenu(evt);
        }
    }

    private static void showMenu(EventObject e) {
        JGSplitButton b = (JGSplitButton)e.getSource();
        if (!b.isShowing()) {
            return;
        }
        b.getMenu().show(b, 0, b.getHeight() + 1);
    }

    @Override
    public final void addActionListener(ActionListener delegate) {
        if (delegate == null) {
            return;
        }
        super.addActionListener(new SplitActionListener(this, delegate));
    }

    @Override
    public final void removeActionListener(ActionListener delegate) {
        if (delegate == null) {
            return;
        }
        for (ActionListener listener : this.getActionListeners()) {
            SplitActionListener splitListener = (SplitActionListener)listener;
            if (splitListener.delegate != delegate) continue;
            super.removeActionListener(listener);
            return;
        }
    }

    @Override
    public void setMargin(Insets margin) {
        int marginRight = margin.right + this.getPopupAreaWidth();
        super.setMargin(new Insets(margin.top, margin.left, margin.bottom, marginRight));
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintPopupIcon(g);
        if (this.isSeparatorPaintedAlways() || this.getModel().isPressed() && this.getModel().isArmed() || this.getModel().isRollover()) {
            this.paintSeparator(g);
        }
    }

    private void paintPopupIcon(Graphics g) {
        Insets insets = this.getInsets();
        int x = this.getPopupAreaX() + (this.getPopupAreaWidth() - this.popupIcon.getIconWidth()) / 2;
        int y = insets.top + 1 + (this.getHeight() - insets.top - insets.bottom - this.popupIcon.getIconHeight()) / 2;
        this.popupIcon.paintIcon(this, g, x, y);
    }

    private void paintSeparator(Graphics g) {
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        int x = this.getPopupAreaX();
        int y = insets.top - margin.top + 1;
        int sHeight = this.getHeight() - (insets.top - margin.top + insets.bottom - margin.bottom) - 2;
        if (this.isFocusOwner() && this.isFocusPainted()) {
            ++y;
            sHeight -= 2;
        }
        g.setColor(UIManager.getColor("controlShadow"));
        g.fillRect(x, y, 1, sHeight);
    }

    protected int getPopupAreaWidth() {
        return POPUP_AREA_WIDTH;
    }

    private int getPopupAreaX() {
        Insets insets = this.getInsets();
        Insets margin = this.getMargin();
        return this.getWidth() - (insets.right - margin.right) - this.getPopupAreaWidth() + this.getPopupPlatformOffsetX();
    }

    protected int getPopupPlatformOffsetX() {
        return SystemUtils.IS_OS_MAC && this.getIcon() == null ? 11 : 0;
    }

    protected boolean isSeparatorPaintedAlways() {
        return true;
    }

    protected Icon getPopupIcon() {
        return TextFieldIcons.getPopupIcon();
    }

    @Override
    public void updateUI() {
        this.removeMouseListener(this.mousePressedListener);
        this.removeMouseListener(this.mouseReleasedListener);
        super.updateUI();
        this.addMouseListener(this.mousePressedListener);
        this.addMouseListener(this.mouseReleasedListener);
    }

    private static final class SplitActionListener
    implements ActionListener {
        private final JGSplitButton button;
        private final ActionListener delegate;

        private SplitActionListener(JGSplitButton button, ActionListener delegate) {
            this.button = Preconditions.checkNotNull(button, "The %s must not be null.", "button");
            this.delegate = Preconditions.checkNotNull(delegate, "The %s must not be null.", "listener");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.button.mousePressedInPopupArea) {
                JGSplitButton.showMenu(evt);
            } else {
                this.delegate.actionPerformed(evt);
            }
        }
    }
}

