/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.persistency;

import com.jgoodies.app.persistency.Entity;
import com.jgoodies.app.persistency.EntityManager;
import com.jgoodies.app.persistency.FakeQuery;
import com.jgoodies.app.persistency.FakeTypedQuery;
import com.jgoodies.app.persistency.Query;
import com.jgoodies.app.persistency.TypedQuery;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class FakeEntityManager
implements EntityManager {
    private final Map<Class<?>, Map<Object, ? extends Entity>> dataStore = new HashMap();
    private long nextId = 0L;

    FakeEntityManager() {
    }

    @Override
    public <T extends Entity> T find(Class<T> entityClass, Object primaryKey) {
        Preconditions.checkNotNull(entityClass, "The %s must not be null.", "entity class");
        Map<Object, T> classStore = this.getClassStore(entityClass);
        return (T)((Entity)Objects.deepCopy((Serializable)classStore.get(primaryKey)));
    }

    @Override
    public void persist(Entity entity) {
        Preconditions.checkNotNull(entity, "The %s must not be null.", "entity");
        Preconditions.checkArgument(!entity.isPersistent(), "Entity already persistent.");
        entity.setId(this.nextId++);
        entity.modify();
        Class<?> entityClass = entity.getClass();
        Map<Object, ?> classStore = this.getClassStore(entityClass);
        Entity previousValue = classStore.put(entity.getId(), entity);
        if (previousValue != null) {
            throw new IllegalArgumentException("Entity already managed.");
        }
    }

    @Override
    public <T extends Entity> T merge(T entity) {
        Preconditions.checkNotNull(entity, "The %s must not be null.", "entity");
        T copy = Objects.deepCopy(entity);
        if (!entity.isPersistent()) {
            this.persist(copy);
            return copy;
        }
        Class<?> entityClass = entity.getClass();
        Map<Object, ?> classStore = this.getClassStore(entityClass);
        Object managed = classStore.put(entity.getId(), copy);
        Preconditions.checkState(managed != null, "The entity is not managed by this manager.");
        copy.modify();
        return copy;
    }

    @Override
    public void remove(Entity entity) {
        Preconditions.checkNotNull(entity, "The %s must not be null.", "entity");
        Class<?> entityClass = entity.getClass();
        Map<Object, ?> classStore = this.getClassStore(entityClass);
        Object value = classStore.remove(entity.getId());
        if (value == null) {
            throw new IllegalArgumentException("Entity not persistent.");
        }
    }

    @Override
    public Query createQuery(String queryString) {
        Class<?> entityClass;
        Preconditions.checkNotBlank(queryString, "The %s must not be null, empty, or whitespace.", "query string");
        if (!queryString.startsWith("count * from ")) {
            throw new UnsupportedOperationException("This fake entity manager can only create queries that count elements.");
        }
        String querySuffix = queryString.substring(12);
        try {
            entityClass = Class.forName(querySuffix);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Unknown entity class " + querySuffix);
        }
        ArrayList<Integer> singleElementList = new ArrayList<Integer>();
        Map<Object, ?> classStore = this.getClassStore(entityClass);
        singleElementList.add(classStore.entrySet().size());
        return new FakeQuery(singleElementList);
    }

    @Override
    public <T extends Entity> TypedQuery<T> createTypedQuery(String queryString, Class<T> resultClass) {
        Preconditions.checkNotBlank(queryString, "The %s must not be null, empty, or whitespace.", "query string");
        Preconditions.checkNotNull(resultClass, "The %s must not be null.", "result class");
        if (!queryString.startsWith("select * from")) {
            throw new UnsupportedOperationException("This fake entity manager can only create typed queries that return all elements of a type.");
        }
        ArrayList<T> entities = new ArrayList<T>();
        Map<Object, T> classStore = this.getClassStore(resultClass);
        entities.addAll(classStore.values());
        return new FakeTypedQuery(entities);
    }

    private <T extends Entity> Map<Object, T> getClassStore(Class<T> entityClass) {
        Map<Object, ? extends Entity> typedMap;
        Map<Object, ? extends Entity> rawMap = this.dataStore.get(entityClass);
        if (rawMap == null) {
            typedMap = new HashMap<Object, Entity>();
            this.dataStore.put(entityClass, typedMap);
        } else {
            typedMap = rawMap;
        }
        return typedMap;
    }
}

