/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.contact;

import com.jgoodies.app.domain.contact.ContactData;
import com.jgoodies.app.persistency.Entity;
import com.jgoodies.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BasePartner<A, CP>
extends Entity {
    public static final String PROPERTY_ADDRESSES = "addresses";
    public static final String PROPERTY_CONTACT_DATA = "contactData";
    public static final String PROPERTY_CONTACT_PERSONS = "contactPersons";
    private final List<A> addresses = new ArrayList<A>();
    private final List<ContactData> contactData = new ArrayList<ContactData>();
    private final List<CP> contactPersons = new ArrayList<CP>();

    public List<A> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void setAddresses(List<A> newAddresses) {
        Preconditions.checkNotNull(newAddresses, "The %s must not be null.", "address list");
        this.addresses.clear();
        this.addresses.addAll(newAddresses);
        this.firePropertyChange(PROPERTY_ADDRESSES, null, this.getAddresses());
    }

    public void addAddress(A address) {
        Preconditions.checkNotNull(address, "The %s must not be null.", "address to add");
        if (this.addresses.contains(address)) {
            return;
        }
        this.addresses.add(address);
        this.firePropertyChange(PROPERTY_ADDRESSES, null, this.getAddresses());
    }

    public void removeAddress(A address) {
        Preconditions.checkNotNull(address, "The %s must not be null.", "address to remove");
        this.addresses.remove(address);
        this.firePropertyChange(PROPERTY_ADDRESSES, null, this.getAddresses());
    }

    public List<ContactData> getContactData() {
        return Collections.unmodifiableList(this.contactData);
    }

    public void setContactData(List<ContactData> newData) {
        Preconditions.checkNotNull(newData, "The %s must not be null.", "contact data list");
        this.contactData.clear();
        this.contactData.addAll(newData);
        this.firePropertyChange(PROPERTY_CONTACT_DATA, null, this.getContactData());
    }

    public void addContactData(ContactData data) {
        Preconditions.checkNotNull(data, "The %s must not be null.", "contact data to add");
        if (this.contactData.contains(data)) {
            return;
        }
        this.contactData.add(data);
        this.firePropertyChange(PROPERTY_CONTACT_DATA, null, this.getContactData());
    }

    public void removeContactData(ContactData data) {
        Preconditions.checkNotNull(data, "The %s must not be null.", "contact data to remove");
        this.contactData.remove(data);
        this.firePropertyChange(PROPERTY_CONTACT_DATA, null, this.getContactData());
    }

    public List<CP> getContactPersons() {
        return Collections.unmodifiableList(this.contactPersons);
    }

    public void addContactPerson(CP person) {
        Preconditions.checkNotNull(person, "The %s must not be null.", "contact person to add");
        if (this.contactPersons.contains(person)) {
            return;
        }
        this.contactPersons.add(person);
        this.firePropertyChange(PROPERTY_CONTACT_PERSONS, null, this.getContactPersons());
    }

    public void removeContactPerson(CP person) {
        Preconditions.checkNotNull(person, "The %s must not be null.", "contact person to remove");
        this.contactPersons.remove(person);
        this.firePropertyChange(PROPERTY_CONTACT_PERSONS, null, this.getContactPersons());
    }

    public Optional<A> firstAddress() {
        return this.addresses.stream().findFirst();
    }

    public Optional<ContactData> firstPhone() {
        return this.first(ContactData.ContactType.PHONE);
    }

    public Optional<ContactData> firstPhone(String label) {
        return this.first(ContactData.ContactType.PHONE, label);
    }

    public Optional<ContactData> firstEmail() {
        return this.first(ContactData.ContactType.EMAIL);
    }

    public Optional<ContactData> firstWeb() {
        return this.first(ContactData.ContactType.WEB);
    }

    public Optional<CP> firstContactPerson() {
        return this.contactPersons.stream().findFirst();
    }

    public List<ContactData> allPhone() {
        return this.all(ContactData.ContactType.PHONE);
    }

    public List<ContactData> allEmail() {
        return this.all(ContactData.ContactType.EMAIL);
    }

    public List<ContactData> allWeb() {
        return this.all(ContactData.ContactType.WEB);
    }

    public List<ContactData> allFacebook() {
        return this.all(ContactData.ContactType.FACEBOOK);
    }

    private List<ContactData> all(ContactData.ContactType type) {
        return this.contactData.stream().filter(data -> data.getType() == type).collect(Collectors.toList());
    }

    private Optional<ContactData> first(ContactData.ContactType type) {
        Preconditions.checkNotNull(type, "The %s must not be null.", "contact type");
        return this.contactData.stream().filter(data -> data.getType() == type).findFirst();
    }

    private Optional<ContactData> first(ContactData.ContactType type, String label) {
        Preconditions.checkNotNull(type, "The %s must not be null.", "contact type");
        return this.contactData.stream().filter(data -> data.getType() == type).filter(data -> data.getLabel().equals(label)).findFirst();
    }

    public static abstract class AbstractBuilder<A, CP, P extends BasePartner<A, CP>, B extends AbstractBuilder<A, CP, P, ?>> {
        protected final P target;

        protected AbstractBuilder(P target) {
            this.target = target;
        }

        public B addAddress(A address) {
            ((BasePartner)this.target).addAddress(address);
            return (B)this;
        }

        public B addContactData(ContactData data) {
            ((BasePartner)this.target).addContactData(data);
            return (B)this;
        }

        public B addContactPerson(CP person) {
            ((BasePartner)this.target).addContactPerson(person);
            return (B)this;
        }

        public B phone(String value) {
            return this.addContactData(new ContactData.Builder().phone(value).build());
        }

        public B mobile(String value) {
            return this.addContactData(new ContactData.Builder().mobile(value).build());
        }

        public B fax(String value) {
            return this.addContactData(new ContactData.Builder().fax(value).build());
        }

        public B email(String value) {
            return this.addContactData(new ContactData.Builder().email(value).build());
        }

        public B web(String value) {
            return this.addContactData(new ContactData.Builder().web(value).build());
        }

        public B facebook(String value) {
            return this.addContactData(new ContactData.Builder().facebook(value).build());
        }
    }
}

