---
myst:
  html_meta:
    keywords: LaTeX, frichiers, fontes, polices de caractères, dessin des caractères, Metafont
---

# Comment créer des polices vectorielles à partir de MetaFont ?

[TeXtrace](https://sourceforge.net/projects/textrace/), développé à l'origine par Péter Szabó, 
est un [ensemble de scripts Unix](http://web.archive.org/web/20231002073155/https://pts.50.hu/textrace/) 
qui utilise le logiciel gratuit de traçage de bordues de Martin Weber 
[autotrace](https://autotrace.sourceforge.net/) pour générer des polices de caractères de type 1 
à partir des sorties de polices matricielles de MetaFont. 
Le résultat ne sera probablement jamais de la qualité d'une police de type 1 produite commercialement, 
mais l'éditeur de polices [FontForge](https://fontforge.org/) pourra sans doute arranger les choses. 
Quoi qu'il en soit, cela met à disposition des polices que beaucoup de gens trouvent utiles 
et qui n'attirent pas les experts rémunérés. De plus, l'auto-tracing fournit un service utile dans ce cas.

Parmi les jeux de polices générés à l'aide de `TeXtrace`, 
on peut citer le jeu de polices *European Computer*/*TeX Companion* de Péter Szabó, `tt2001`, 
ainsi que le jeu *CM-Super* de Vladimir Volovich, qui couvre les jeux de polices *European Computer*, 
*TeX Companion* et Cyrillic LH (pour plus de détails sur ces deux jeux, 
consultez la question "[](/5_fichiers/formats/fontes/fontes_t1_8bits)").

Un autre système, arrivé un peu plus tard, est [mftrace](http://lilypond.org/mftrace/) : 
c'est un petit programme Python qui fait le même travail. 
`Mftrace` peut utiliser soit `autotrace` (comme `TeXtrace`), 
soit [potrace](https://potrace.sourceforge.net/) de Peter Selinger 
pour produire les contours initiaux à traiter. 
On dit que `Mftrace` est plus flexible et plus facile à utiliser que `TeXtrace`, 
mais les deux systèmes sont de plus en plus utilisés pour fournir des polices de type 1 au domaine public.

Le système `MetaType1` vise à utiliser les sources de polices MetaFont, 
par le biais de MetaPost et d'un tas de scripts, pour produire des polices de type 1 de haute qualité. 
Les premiers résultats, les polices [Latin Modern](https://ctan.org/pkg/lm), 
sont maintenant bien établis, 
et un certain nombre de modèles existants ont été retravaillés au format MetaType1.

<ctanpkg:Mf2pt1> est un autre traducteur des sources de polices MetaFont par le biais de MetaPost.
De plus, <ctanpkg:mf2pt1> utilisera [Fontforge](https://fontforge.org/) (s'il est disponible) 
pour améliorer automatiquement le résultat de sa conversion 
(<ctanpkg:Mf2pt1> est également écrit en `perl`).


:::{sources}
[Making outline fonts from MetaFont](faquk:FAQ-textrace)
:::