---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, maquette, 
              sous-bibliographies
---

# Comment obtenir des bibliographies séparées par chapitre ?

## Avec l'extension <ctanpkg:chapterbib>

Pour avoir une bibliographie séparée pour chaque "chapitre" d'un document, 
on peut utiliser l'extension <ctanpkg:chapterbib> (qui fournit pas mal 
d'autres fonctionnalités utiles pour les bibliographies).

Cette extension vous permet d'avoir une bibliographie individuelle 
pour chaque fichier `\include` : ainsi, malgré le nom de l'extension, 
la construction des bibliographies se base sur les différents fichiers sources
du document plutôt que sur les chapitres définis par sa structure logique. 
L'extension permet également d'avoir une bibliographie globale 
pour le document.


## Avec l'extension <ctanpkg:bibunits>

L'extension <ctanpkg:bibunits>, elle, lie les bibliographies 
aux unités logiques du document : elle traite les chapitres et les sections 
(comme définis par LaTeX), et définit également un environnement `bibunit` 
afin que l'utilisateur puisse sélectionner sa propre structuration.

```{noedit}
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bibunits}

\begin{document}
\bibliographyunit[\chapter]
\bibliographystyle{plain}
\bibliography{geometrie,algorithmes}

\chapter{Algorithmes.}
Présentation d'algorithmes. \nocite{*}
\putbib[algorithmes]

\chapter{Géométrie.}
Texte sur la géométrie. \nocite{*}
\putbib[geometrie]
\end{document}
```

La compilation de cet exemple entraîne la création 
de plusieurs fichiers `.aux`, qu'il faudra ensuite passer à `BibTeX`.


## Avec l'extension [BibLaTeX](ctanpkg:biblatex) (et <ctanpkg:biber>)

L'extension [BibLaTeX](ctanpkg:biblatex), avec <ctanpkg:biber>, 
[fournit une fonction similaire](/3_composition/annexes/bibliographie/remplacer_bibtex) : 
ajoutez le texte pour lequel vous souhaitez une bibliographie locale 
dans un environnement `refsection`, et ajoutez à la fin de cet environnement
la commande `\printbibliography` :

```{noedit}
\begin{refsection}
\chapter{Premier chapitre}
\section{Ma section}
Du texte\cite{Ceci} avec de références\cite{Cela}.

\printbibliography
\end{refsection}
```

Ensuite, compilez avec LaTeX (pdfLaTeX, XeLaTeX, LuaLaTeX... peu importe) 
et lancez `biber` pour traiter la bibliographie. Notez que `\printbibliography`
peut prendre un argument optionnel `heading=titre biblio` 
pour que la bibliographie ait un titre de (sous-)section.


:::{sources}
- [Separate bibliographies per chapter?](faquk:FAQ-chapbib)
- [LaTeX: bibliography per chapter](https://stackoverflow.com/q/2765209), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::