package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDevice invokes the vs.StartDevice API synchronously
func (client *Client) StartDevice(request *StartDeviceRequest) (response *StartDeviceResponse, err error) {
	response = CreateStartDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// StartDeviceWithChan invokes the vs.StartDevice API asynchronously
func (client *Client) StartDeviceWithChan(request *StartDeviceRequest) (<-chan *StartDeviceResponse, <-chan error) {
	responseChan := make(chan *StartDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDeviceWithCallback invokes the vs.StartDevice API asynchronously
func (client *Client) StartDeviceWithCallback(request *StartDeviceRequest, callback func(response *StartDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDeviceResponse
		var err error
		defer close(result)
		response, err = client.StartDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDeviceRequest is the request struct for api StartDevice
type StartDeviceRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// StartDeviceResponse is the response struct for api StartDevice
type StartDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateStartDeviceRequest creates a request to invoke StartDevice API
func CreateStartDeviceRequest() (request *StartDeviceRequest) {
	request = &StartDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StartDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDeviceResponse creates a response to parse from StartDevice response
func CreateStartDeviceResponse() (response *StartDeviceResponse) {
	response = &StartDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
