package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainDetail invokes the dcdn.DescribeDcdnDomainDetail API synchronously
func (client *Client) DescribeDcdnDomainDetail(request *DescribeDcdnDomainDetailRequest) (response *DescribeDcdnDomainDetailResponse, err error) {
	response = CreateDescribeDcdnDomainDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainDetailWithChan invokes the dcdn.DescribeDcdnDomainDetail API asynchronously
func (client *Client) DescribeDcdnDomainDetailWithChan(request *DescribeDcdnDomainDetailRequest) (<-chan *DescribeDcdnDomainDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainDetailWithCallback invokes the dcdn.DescribeDcdnDomainDetail API asynchronously
func (client *Client) DescribeDcdnDomainDetailWithCallback(request *DescribeDcdnDomainDetailRequest, callback func(response *DescribeDcdnDomainDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainDetailRequest is the request struct for api DescribeDcdnDomainDetail
type DescribeDcdnDomainDetailRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeDcdnDomainDetailResponse is the response struct for api DescribeDcdnDomainDetail
type DescribeDcdnDomainDetailResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DomainDetail DomainDetail `json:"DomainDetail" xml:"DomainDetail"`
}

// CreateDescribeDcdnDomainDetailRequest creates a request to invoke DescribeDcdnDomainDetail API
func CreateDescribeDcdnDomainDetailRequest() (request *DescribeDcdnDomainDetailRequest) {
	request = &DescribeDcdnDomainDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainDetailResponse creates a response to parse from DescribeDcdnDomainDetail response
func CreateDescribeDcdnDomainDetailResponse() (response *DescribeDcdnDomainDetailResponse) {
	response = &DescribeDcdnDomainDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
