package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDbfsSpecifications invokes the dbfs.DescribeDbfsSpecifications API synchronously
func (client *Client) DescribeDbfsSpecifications(request *DescribeDbfsSpecificationsRequest) (response *DescribeDbfsSpecificationsResponse, err error) {
	response = CreateDescribeDbfsSpecificationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDbfsSpecificationsWithChan invokes the dbfs.DescribeDbfsSpecifications API asynchronously
func (client *Client) DescribeDbfsSpecificationsWithChan(request *DescribeDbfsSpecificationsRequest) (<-chan *DescribeDbfsSpecificationsResponse, <-chan error) {
	responseChan := make(chan *DescribeDbfsSpecificationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDbfsSpecifications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDbfsSpecificationsWithCallback invokes the dbfs.DescribeDbfsSpecifications API asynchronously
func (client *Client) DescribeDbfsSpecificationsWithCallback(request *DescribeDbfsSpecificationsRequest, callback func(response *DescribeDbfsSpecificationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDbfsSpecificationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDbfsSpecifications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDbfsSpecificationsRequest is the request struct for api DescribeDbfsSpecifications
type DescribeDbfsSpecificationsRequest struct {
	*requests.RpcRequest
	EcsInstanceType string `position:"Query" name:"EcsInstanceType"`
	Category        string `position:"Query" name:"Category"`
}

// DescribeDbfsSpecificationsResponse is the response struct for api DescribeDbfsSpecifications
type DescribeDbfsSpecificationsResponse struct {
	*responses.BaseResponse
	RequestId                      string                 `json:"RequestId" xml:"RequestId"`
	MaxDbfsNumberPerEcs            map[string]interface{} `json:"MaxDbfsNumberPerEcs" xml:"MaxDbfsNumberPerEcs"`
	SupportedEcsInstanceTypeFamily []string               `json:"SupportedEcsInstanceTypeFamily" xml:"SupportedEcsInstanceTypeFamily"`
}

// CreateDescribeDbfsSpecificationsRequest creates a request to invoke DescribeDbfsSpecifications API
func CreateDescribeDbfsSpecificationsRequest() (request *DescribeDbfsSpecificationsRequest) {
	request = &DescribeDbfsSpecificationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "DescribeDbfsSpecifications", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDbfsSpecificationsResponse creates a response to parse from DescribeDbfsSpecifications response
func CreateDescribeDbfsSpecificationsResponse() (response *DescribeDbfsSpecificationsResponse) {
	response = &DescribeDbfsSpecificationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
