package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExporterOutputList invokes the cms.DescribeExporterOutputList API synchronously
func (client *Client) DescribeExporterOutputList(request *DescribeExporterOutputListRequest) (response *DescribeExporterOutputListResponse, err error) {
	response = CreateDescribeExporterOutputListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExporterOutputListWithChan invokes the cms.DescribeExporterOutputList API asynchronously
func (client *Client) DescribeExporterOutputListWithChan(request *DescribeExporterOutputListRequest) (<-chan *DescribeExporterOutputListResponse, <-chan error) {
	responseChan := make(chan *DescribeExporterOutputListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExporterOutputList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExporterOutputListWithCallback invokes the cms.DescribeExporterOutputList API asynchronously
func (client *Client) DescribeExporterOutputListWithCallback(request *DescribeExporterOutputListRequest, callback func(response *DescribeExporterOutputListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExporterOutputListResponse
		var err error
		defer close(result)
		response, err = client.DescribeExporterOutputList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExporterOutputListRequest is the request struct for api DescribeExporterOutputList
type DescribeExporterOutputListRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeExporterOutputListResponse is the response struct for api DescribeExporterOutputList
type DescribeExporterOutputListResponse struct {
	*responses.BaseResponse
	RequestId  string                                 `json:"RequestId" xml:"RequestId"`
	Success    bool                                   `json:"Success" xml:"Success"`
	Code       string                                 `json:"Code" xml:"Code"`
	Message    string                                 `json:"Message" xml:"Message"`
	PageNumber int                                    `json:"PageNumber" xml:"PageNumber"`
	Total      int                                    `json:"Total" xml:"Total"`
	Datapoints DatapointsInDescribeExporterOutputList `json:"Datapoints" xml:"Datapoints"`
}

// CreateDescribeExporterOutputListRequest creates a request to invoke DescribeExporterOutputList API
func CreateDescribeExporterOutputListRequest() (request *DescribeExporterOutputListRequest) {
	request = &DescribeExporterOutputListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeExporterOutputList", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExporterOutputListResponse creates a response to parse from DescribeExporterOutputList response
func CreateDescribeExporterOutputListResponse() (response *DescribeExporterOutputListResponse) {
	response = &DescribeExporterOutputListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
