package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRIUtilizationDetail invokes the bssopenapi.QueryRIUtilizationDetail API synchronously
func (client *Client) QueryRIUtilizationDetail(request *QueryRIUtilizationDetailRequest) (response *QueryRIUtilizationDetailResponse, err error) {
	response = CreateQueryRIUtilizationDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRIUtilizationDetailWithChan invokes the bssopenapi.QueryRIUtilizationDetail API asynchronously
func (client *Client) QueryRIUtilizationDetailWithChan(request *QueryRIUtilizationDetailRequest) (<-chan *QueryRIUtilizationDetailResponse, <-chan error) {
	responseChan := make(chan *QueryRIUtilizationDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRIUtilizationDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRIUtilizationDetailWithCallback invokes the bssopenapi.QueryRIUtilizationDetail API asynchronously
func (client *Client) QueryRIUtilizationDetailWithCallback(request *QueryRIUtilizationDetailRequest, callback func(response *QueryRIUtilizationDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRIUtilizationDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryRIUtilizationDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRIUtilizationDetailRequest is the request struct for api QueryRIUtilizationDetail
type QueryRIUtilizationDetailRequest struct {
	*requests.RpcRequest
	DeductedInstanceId string           `position:"Query" name:"DeductedInstanceId"`
	InstanceSpec       string           `position:"Query" name:"InstanceSpec"`
	EndTime            string           `position:"Query" name:"EndTime"`
	RIInstanceId       string           `position:"Query" name:"RIInstanceId"`
	StartTime          string           `position:"Query" name:"StartTime"`
	PageNum            requests.Integer `position:"Query" name:"PageNum"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	RICommodityCode    string           `position:"Query" name:"RICommodityCode"`
}

// QueryRIUtilizationDetailResponse is the response struct for api QueryRIUtilizationDetail
type QueryRIUtilizationDetailResponse struct {
	*responses.BaseResponse
	Code      string                         `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   bool                           `json:"Success" xml:"Success"`
	Data      DataInQueryRIUtilizationDetail `json:"Data" xml:"Data"`
}

// CreateQueryRIUtilizationDetailRequest creates a request to invoke QueryRIUtilizationDetail API
func CreateQueryRIUtilizationDetailRequest() (request *QueryRIUtilizationDetailRequest) {
	request = &QueryRIUtilizationDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryRIUtilizationDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRIUtilizationDetailResponse creates a response to parse from QueryRIUtilizationDetail response
func CreateQueryRIUtilizationDetailResponse() (response *QueryRIUtilizationDetailResponse) {
	response = &QueryRIUtilizationDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
