//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbit?language=objc)
pub type CFBit = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfbitvector?language=objc)
#[repr(C)]
pub struct CFBitVector {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFBitVector"]
    unsafe impl CFBitVector {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutablebitvector?language=objc)
#[repr(C)]
pub struct CFMutableBitVector {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFBitVector"]
    unsafe impl CFMutableBitVector: CFBitVector {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFBitVector {
    #[doc(alias = "CFBitVectorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBitVectorGetTypeID() -> CFTypeID;
        }
        unsafe { CFBitVectorGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreate(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    num_bits: CFIndex,
) -> Option<CFRetained<CFBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreate(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            num_bits: CFIndex,
        ) -> Option<NonNull<CFBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreate(allocator, bytes, num_bits) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateCopy(
    allocator: Option<&CFAllocator>,
    bv: Option<&CFBitVector>,
) -> Option<CFRetained<CFBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateCopy(
            allocator: Option<&CFAllocator>,
            bv: Option<&CFBitVector>,
        ) -> Option<NonNull<CFBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateCopy(allocator, bv) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
) -> Option<CFRetained<CFMutableBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
        ) -> Option<NonNull<CFMutableBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateMutable(allocator, capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    bv: Option<&CFBitVector>,
) -> Option<CFRetained<CFMutableBitVector>> {
    extern "C-unwind" {
        fn CFBitVectorCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            bv: Option<&CFBitVector>,
        ) -> Option<NonNull<CFMutableBitVector>>;
    }
    let ret = unsafe { CFBitVectorCreateMutableCopy(allocator, capacity, bv) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetCount(bv: &CFBitVector) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetCountOfBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFBitVectorContainsBit(
    bv: &CFBitVector,
    range: CFRange,
    value: CFBit,
) -> bool {
    extern "C-unwind" {
        fn CFBitVectorContainsBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> Boolean;
    }
    let ret = unsafe { CFBitVectorContainsBit(bv, range, value) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetBitAtIndex(bv: &CFBitVector, idx: CFIndex) -> CFBit;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetBits(bv: &CFBitVector, range: CFRange, bytes: *mut u8);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetFirstIndexOfBit(bv: &CFBitVector, range: CFRange, value: CFBit)
        -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorGetLastIndexOfBit(bv: &CFBitVector, range: CFRange, value: CFBit) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorSetCount(bv: Option<&CFMutableBitVector>, count: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorFlipBitAtIndex(bv: Option<&CFMutableBitVector>, idx: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorFlipBits(bv: Option<&CFMutableBitVector>, range: CFRange);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorSetBitAtIndex(bv: Option<&CFMutableBitVector>, idx: CFIndex, value: CFBit);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFBitVectorSetBits(bv: Option<&CFMutableBitVector>, range: CFRange, value: CFBit);
}

extern "C-unwind" {
    pub fn CFBitVectorSetAllBits(bv: Option<&CFMutableBitVector>, value: CFBit);
}
