// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudConsulTelemetry20230414Intentions intentions describe the intentions that allow/deny traffic between services.
//
// swagger:model hashicorp.cloud.consul_telemetry_20230414.Intentions
type HashicorpCloudConsulTelemetry20230414Intentions struct {

	// authorization describes whether the call from the downstream service to the upstream service was
	// allowed after factoring in all intentions and the acl.default_policy.
	Authorization *HashicorpCloudConsulTelemetry20230414IntentionsAuthorization `json:"authorization,omitempty"`

	// entries is the set of intention entries that apply to the call between the downstream and upstream
	// service. These are sorted from highest precedence (ie the intention that actually applied) to lowest.
	Entries []*HashicorpCloudConsulTelemetry20230414IntentionsEntry `json:"entries"`
}

// Validate validates this hashicorp cloud consul telemetry 20230414 intentions
func (m *HashicorpCloudConsulTelemetry20230414Intentions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthorization(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntries(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414Intentions) validateAuthorization(formats strfmt.Registry) error {
	if swag.IsZero(m.Authorization) { // not required
		return nil
	}

	if m.Authorization != nil {
		if err := m.Authorization.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authorization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("authorization")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414Intentions) validateEntries(formats strfmt.Registry) error {
	if swag.IsZero(m.Entries) { // not required
		return nil
	}

	for i := 0; i < len(m.Entries); i++ {
		if swag.IsZero(m.Entries[i]) { // not required
			continue
		}

		if m.Entries[i] != nil {
			if err := m.Entries[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud consul telemetry 20230414 intentions based on the context it is used
func (m *HashicorpCloudConsulTelemetry20230414Intentions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuthorization(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntries(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414Intentions) contextValidateAuthorization(ctx context.Context, formats strfmt.Registry) error {

	if m.Authorization != nil {

		if swag.IsZero(m.Authorization) { // not required
			return nil
		}

		if err := m.Authorization.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authorization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("authorization")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414Intentions) contextValidateEntries(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Entries); i++ {

		if m.Entries[i] != nil {

			if swag.IsZero(m.Entries[i]) { // not required
				return nil
			}

			if err := m.Entries[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("entries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("entries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414Intentions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414Intentions) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudConsulTelemetry20230414Intentions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
