/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth.access;

import com.dtolabs.rundeck.core.authorization.AuthContextProcessor;
import com.dtolabs.rundeck.core.authorization.AuthResource;
import java.util.Optional;
import javax.security.auth.Subject;
import org.rundeck.core.auth.access.AuthActions;
import org.rundeck.core.auth.access.AuthorizingResource;
import org.rundeck.core.auth.access.BaseAuthorizingAccess;
import org.rundeck.core.auth.access.NamedAuthProvider;
import org.rundeck.core.auth.access.NotFound;
import org.rundeck.core.auth.access.UnauthorizedAccess;

public abstract class BaseAuthorizingResource<T>
extends BaseAuthorizingAccess
implements AuthorizingResource<T> {
    public BaseAuthorizingResource(AuthContextProcessor rundeckAuthContextProcessor, Subject subject, NamedAuthProvider namedAuthActions) {
        super(rundeckAuthContextProcessor, subject, namedAuthActions);
    }

    protected abstract AuthResource getAuthResource(T var1);

    @Override
    protected abstract String getResourceTypeName();

    @Override
    protected abstract String getResourceIdent();

    protected abstract Optional<T> retrieve();

    protected abstract boolean exists();

    @Override
    public T access(AuthActions actions) throws UnauthorizedAccess, NotFound {
        return this.requireActions(actions);
    }

    @Override
    public void authorize(AuthActions actions) throws UnauthorizedAccess, NotFound {
        this.requireActions(actions);
    }

    @Override
    protected AuthResource getAuthResource() throws NotFound {
        Optional<T> res = this.retrieve();
        return this.getAuthResource(res.orElseThrow(() -> new NotFound(this.getResourceTypeName(), this.getResourceIdent())));
    }

    public T requireActions(AuthActions actions) throws UnauthorizedAccess, NotFound {
        if (!this.isAuthorized(actions)) {
            throw new UnauthorizedAccess(actions.getDescription(), this.getResourceTypeName(), this.getResourceIdent());
        }
        return this.getResource();
    }

    @Override
    public T getResource() throws NotFound {
        Optional<T> retrieve = this.retrieve();
        return retrieve.orElseThrow(() -> new NotFound(this.getResourceTypeName(), this.getResourceIdent()));
    }
}

