# Using Doxygen

BuildTools provides some additional support to use [Doxygen](https://www.doxygen.nl) for in-code documentation automatically as part of the standard build harness.
Briefly, documentation is generated by scanning source files (by default, only `.h` and `.hpp` files) which have been annotated with comments and doxygen markup.
<!--As an example, here's the [doxygen documentation generated for Osi](http://www.coin-or.org/Doxygen/Osi/index.html).-->
Complete [on-line doxygen documentation](https://www.doxygen.nl/manual/index.html) is available there.

Doxygen documentation can be built and installed just as the code is built and installed.
Doxygen documentation for a given project or package can be linked with doxygen documentation for other projects or packages, within the limits of doxygen's ability.

To use Doxygen, you should first document your code using Doxygen markup.
Doxygen markup is designed to be minimally intrusive and works well with common styles of in-code documentation.
Even with zero markup, Doxygen will still generate minimal documentation showing classes and structures, their members, and their interrelationships (_e.g._, [DyLP](http://www.coin-or.org/Doxygen/DyLP)).
<!--Consult the source code for any of the COIN-OR projects that have documentation [here](http://www.coin-or.org/Doxygen).-->

For the remainder of this page, [Osi](https://projects.coin-or.org/Osi) will be the running example.
Replace 'Osi' with the name of your project. Consult the various files referenced below for examples.


## Setting Up

These steps have already been completed for most projects that use the common build system, so if you are just attempting to generate documentation, please skip to the section on building and installing.


### Step 1: Add `doxygen.conf.in` to repository
The first step in setting things up is to add Doxygen configuration files in the proper places in order to control the documentation that Doxygen produces.
As with many other files, these configuration files are customized and automatically generated by the `configure` script, so you're going to be adding an autoconf file named `doxygen.conf.in` to a directory `doxygen` of your repository.
If you're starting from scratch, you can get samples of the `doxygen.conf.in` files from another project that is already set up and modify them, just to ensure that you have the most current version.
For convenience, however, a [vanilla configuration file](./doxygen.conf.in) is attached.

Once you've installed the `doxygen.conf.in` file, you may wish to adjust it for your project's code.
In particular, look at the section titled 'Configuration options related to the preprocessor' and consider whether you want to instruct Doxygen to consider compilation-time macro definitions.
For example, the entire content of `OsiDylpSolverInterface.hpp` is wrapped with `#ifdef COIN_HAS_DYLP ... #endif`, so `doxygen.conf.in` includes
```
PREDEFINED = COIN_HAS_DYLP
```
Without this, Doxygen would simply see an empty file.


### Step 2: Modify `configure.ac`

The `AC_COIN_DOXYGEN` macro is provided to configure Doxygen processing and to automatically locate the documentation for any externals.
The parameter is a space-separated list of other projects whose Doxygen documentation should be linked with the documentation of the current project.
For example, the Osi library depends on CoinUtils, and the project-level `configure.ac` specifies this dependency as
```
AC_COIN_DOXYGEN(CoinUtils)
```
The Osi package takes a broader view.
There are many implementations of the Osi interface, and it's useful, when browsing the Osi documentation, to be aware of them.
The package level `configure.ac` specifies the relevant projects so that Doxygen can determine which projects reimplement a particular method:
```
AC_COIN_DOXYGEN(CoinUtils Cgl Clp DyLP Vol SYMPHONY)
```
Doxygen is quite forgiving when it comes to linking with other Doxygen documentation; if it can't find a tag file that it wants for linking, you'll get a warning in the log file, but that's all.
However, Doxygen does not do any sort of global linking, nor does it rebuild documentation that is the target of a link.
It looks in a specified tag file for a match; if it finds one, it generates a link.
The net effect is that it may take a few iterations of building and installing the Doxygen documentation before all links are in place.

In addition to a call to `AC_COIN_DOXYGEN`, you'll need to add a call to `AC_CONFIG_FILES` so that `configure` will process `doxygen.conf.in` into `doxygen.conf`:
```
AC_CONFIG_FILES([doxydoc/doxygen.conf])
```
Configuration sets a number of variables in the `doxydoc.conf.in` files so that doxygen can locate source code and the tag files that allow linking with other projects' documentation.

There's one other configuration option, `--with-dot`, which controls doxygen's generation of inheritance and collaboration graphs.
This is on by default but somewhat expensive; to disable it specify `--without-dot` as a configure option.
`configure` will check for the dot tool (part of the [graphviz](http://www.graphviz.org) package) and will disable use of dot if it's not found.
It will also look for LaTeX, since that can be used to build PDF documentation.


### Step 3: Add Targets to `Makefile.am`

Targets for building, installing, uninstalling, and cleaning Doxygen documentation are provided via `BuildTools/Makemain.inc`, so making sure that this file is included by the `Makefile.am` in the main directory is sufficient.

## Building and Installing Documentation

### Automatically generated targets

The `Makefile` in the project's main directory has a target `doxygen-docs` that builds the Doxygen documentation.
Making this target will also create a tags file named `doxydoc/xyz_doxy.tags` that will be used to link the Doxygen documentation of other projects.
There is also a target `pdf-doxygen-docs` that will build a PDF version of the documentation if that is desired.

At configure time, the `AC_COIN_DOXYGEN` macro tries to locate where the tags files for other projects should be found.
It looks for the tags files in the the data installation directory (see below for what gets installed where).
The links generated, however, are relative, so the documentation should link properly both before and after installation and should be completely portable, as long as all doxydoc directories are moved together.


### Installing documentation

For now, the documentation does not get built and installed as part of `make install`, since it is a bit of a pain to have the documentation re-built every time a change in the source is made and new binaries are installed. 

The `Makefile` in the project's main directory has a target `install-doxygen-docs` that will install all existing documentation (both PDF and HTML) and the tags file in the `doxydoc/` subdirectory to the documentation install directory (`<prefix>/share/doc/Xyz` by default).
