/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    private String sequenceName;
    private Class returnClass;
    private String sql;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$id$SequenceGenerator == null ? (class$net$sf$hibernate$id$SequenceGenerator = SequenceGenerator.class$("net.sf.hibernate.id.SequenceGenerator")) : class$net$sf$hibernate$id$SequenceGenerator));
    static /* synthetic */ Class class$net$sf$hibernate$id$SequenceGenerator;

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString(SEQUENCE, params, "hibernate_sequence");
        String schemaName = params.getProperty("schema");
        if (schemaName != null && this.sequenceName.indexOf(46) < 0) {
            this.sequenceName = schemaName + '.' + this.sequenceName;
        }
        this.returnClass = type.getReturnedClass();
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        Number number;
        PreparedStatement st = session.getBatcher().prepareStatement(this.sql);
        try {
            Number result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = IdentifierGeneratorFactory.get(rs, this.returnClass);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            log.debug((Object)("Sequence identifier generated: " + result));
            number = result;
            Object var9_11 = null;
        }
        catch (SQLException sqle) {
            try {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
        }
        session.getBatcher().closeStatement(st);
        return number;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateSequenceString(this.sequenceName)};
    }

    public String sqlDropString(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceString(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

