// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPCheckDefaultsOKCode is the HTTP code returned for type ReplaceHTTPCheckDefaultsOK
const ReplaceHTTPCheckDefaultsOKCode int = 200

/*
ReplaceHTTPCheckDefaultsOK HTTP check replaced

swagger:response replaceHttpCheckDefaultsOK
*/
type ReplaceHTTPCheckDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewReplaceHTTPCheckDefaultsOK creates ReplaceHTTPCheckDefaultsOK with default headers values
func NewReplaceHTTPCheckDefaultsOK() *ReplaceHTTPCheckDefaultsOK {

	return &ReplaceHTTPCheckDefaultsOK{}
}

// WithPayload adds the payload to the replace Http check defaults o k response
func (o *ReplaceHTTPCheckDefaultsOK) WithPayload(payload *models.HTTPCheck) *ReplaceHTTPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check defaults o k response
func (o *ReplaceHTTPCheckDefaultsOK) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckDefaultsAcceptedCode is the HTTP code returned for type ReplaceHTTPCheckDefaultsAccepted
const ReplaceHTTPCheckDefaultsAcceptedCode int = 202

/*
ReplaceHTTPCheckDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceHttpCheckDefaultsAccepted
*/
type ReplaceHTTPCheckDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewReplaceHTTPCheckDefaultsAccepted creates ReplaceHTTPCheckDefaultsAccepted with default headers values
func NewReplaceHTTPCheckDefaultsAccepted() *ReplaceHTTPCheckDefaultsAccepted {

	return &ReplaceHTTPCheckDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace Http check defaults accepted response
func (o *ReplaceHTTPCheckDefaultsAccepted) WithReloadID(reloadID string) *ReplaceHTTPCheckDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http check defaults accepted response
func (o *ReplaceHTTPCheckDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http check defaults accepted response
func (o *ReplaceHTTPCheckDefaultsAccepted) WithPayload(payload *models.HTTPCheck) *ReplaceHTTPCheckDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check defaults accepted response
func (o *ReplaceHTTPCheckDefaultsAccepted) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckDefaultsBadRequestCode is the HTTP code returned for type ReplaceHTTPCheckDefaultsBadRequest
const ReplaceHTTPCheckDefaultsBadRequestCode int = 400

/*
ReplaceHTTPCheckDefaultsBadRequest Bad request

swagger:response replaceHttpCheckDefaultsBadRequest
*/
type ReplaceHTTPCheckDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckDefaultsBadRequest creates ReplaceHTTPCheckDefaultsBadRequest with default headers values
func NewReplaceHTTPCheckDefaultsBadRequest() *ReplaceHTTPCheckDefaultsBadRequest {

	return &ReplaceHTTPCheckDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http check defaults bad request response
func (o *ReplaceHTTPCheckDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http check defaults bad request response
func (o *ReplaceHTTPCheckDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http check defaults bad request response
func (o *ReplaceHTTPCheckDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPCheckDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check defaults bad request response
func (o *ReplaceHTTPCheckDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPCheckDefaultsNotFoundCode is the HTTP code returned for type ReplaceHTTPCheckDefaultsNotFound
const ReplaceHTTPCheckDefaultsNotFoundCode int = 404

/*
ReplaceHTTPCheckDefaultsNotFound The specified resource was not found

swagger:response replaceHttpCheckDefaultsNotFound
*/
type ReplaceHTTPCheckDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckDefaultsNotFound creates ReplaceHTTPCheckDefaultsNotFound with default headers values
func NewReplaceHTTPCheckDefaultsNotFound() *ReplaceHTTPCheckDefaultsNotFound {

	return &ReplaceHTTPCheckDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http check defaults not found response
func (o *ReplaceHTTPCheckDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http check defaults not found response
func (o *ReplaceHTTPCheckDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http check defaults not found response
func (o *ReplaceHTTPCheckDefaultsNotFound) WithPayload(payload *models.Error) *ReplaceHTTPCheckDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http check defaults not found response
func (o *ReplaceHTTPCheckDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPCheckDefaultsDefault General Error

swagger:response replaceHttpCheckDefaultsDefault
*/
type ReplaceHTTPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPCheckDefaultsDefault creates ReplaceHTTPCheckDefaultsDefault with default headers values
func NewReplaceHTTPCheckDefaultsDefault(code int) *ReplaceHTTPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) WithStatusCode(code int) *ReplaceHTTPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) WithPayload(payload *models.Error) *ReplaceHTTPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP check defaults default response
func (o *ReplaceHTTPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
