// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteFilterBackendAcceptedCode is the HTTP code returned for type DeleteFilterBackendAccepted
const DeleteFilterBackendAcceptedCode int = 202

/*
DeleteFilterBackendAccepted Configuration change accepted and reload requested

swagger:response deleteFilterBackendAccepted
*/
type DeleteFilterBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteFilterBackendAccepted creates DeleteFilterBackendAccepted with default headers values
func NewDeleteFilterBackendAccepted() *DeleteFilterBackendAccepted {

	return &DeleteFilterBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete filter backend accepted response
func (o *DeleteFilterBackendAccepted) WithReloadID(reloadID string) *DeleteFilterBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete filter backend accepted response
func (o *DeleteFilterBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteFilterBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteFilterBackendNoContentCode is the HTTP code returned for type DeleteFilterBackendNoContent
const DeleteFilterBackendNoContentCode int = 204

/*
DeleteFilterBackendNoContent Filter deleted

swagger:response deleteFilterBackendNoContent
*/
type DeleteFilterBackendNoContent struct {
}

// NewDeleteFilterBackendNoContent creates DeleteFilterBackendNoContent with default headers values
func NewDeleteFilterBackendNoContent() *DeleteFilterBackendNoContent {

	return &DeleteFilterBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteFilterBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteFilterBackendNotFoundCode is the HTTP code returned for type DeleteFilterBackendNotFound
const DeleteFilterBackendNotFoundCode int = 404

/*
DeleteFilterBackendNotFound The specified resource was not found

swagger:response deleteFilterBackendNotFound
*/
type DeleteFilterBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFilterBackendNotFound creates DeleteFilterBackendNotFound with default headers values
func NewDeleteFilterBackendNotFound() *DeleteFilterBackendNotFound {

	return &DeleteFilterBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete filter backend not found response
func (o *DeleteFilterBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteFilterBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete filter backend not found response
func (o *DeleteFilterBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete filter backend not found response
func (o *DeleteFilterBackendNotFound) WithPayload(payload *models.Error) *DeleteFilterBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete filter backend not found response
func (o *DeleteFilterBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFilterBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteFilterBackendDefault General Error

swagger:response deleteFilterBackendDefault
*/
type DeleteFilterBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFilterBackendDefault creates DeleteFilterBackendDefault with default headers values
func NewDeleteFilterBackendDefault(code int) *DeleteFilterBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteFilterBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete filter backend default response
func (o *DeleteFilterBackendDefault) WithStatusCode(code int) *DeleteFilterBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete filter backend default response
func (o *DeleteFilterBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete filter backend default response
func (o *DeleteFilterBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteFilterBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete filter backend default response
func (o *DeleteFilterBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete filter backend default response
func (o *DeleteFilterBackendDefault) WithPayload(payload *models.Error) *DeleteFilterBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete filter backend default response
func (o *DeleteFilterBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFilterBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
