// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetBindLogForwardOKCode is the HTTP code returned for type GetBindLogForwardOK
const GetBindLogForwardOKCode int = 200

/*
GetBindLogForwardOK Successful operation

swagger:response getBindLogForwardOK
*/
type GetBindLogForwardOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewGetBindLogForwardOK creates GetBindLogForwardOK with default headers values
func NewGetBindLogForwardOK() *GetBindLogForwardOK {

	return &GetBindLogForwardOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind log forward o k response
func (o *GetBindLogForwardOK) WithConfigurationVersion(configurationVersion string) *GetBindLogForwardOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind log forward o k response
func (o *GetBindLogForwardOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind log forward o k response
func (o *GetBindLogForwardOK) WithPayload(payload *models.Bind) *GetBindLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind log forward o k response
func (o *GetBindLogForwardOK) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetBindLogForwardNotFoundCode is the HTTP code returned for type GetBindLogForwardNotFound
const GetBindLogForwardNotFoundCode int = 404

/*
GetBindLogForwardNotFound The specified resource already exists

swagger:response getBindLogForwardNotFound
*/
type GetBindLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindLogForwardNotFound creates GetBindLogForwardNotFound with default headers values
func NewGetBindLogForwardNotFound() *GetBindLogForwardNotFound {

	return &GetBindLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind log forward not found response
func (o *GetBindLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *GetBindLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind log forward not found response
func (o *GetBindLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind log forward not found response
func (o *GetBindLogForwardNotFound) WithPayload(payload *models.Error) *GetBindLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind log forward not found response
func (o *GetBindLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetBindLogForwardDefault General Error

swagger:response getBindLogForwardDefault
*/
type GetBindLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindLogForwardDefault creates GetBindLogForwardDefault with default headers values
func NewGetBindLogForwardDefault(code int) *GetBindLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &GetBindLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get bind log forward default response
func (o *GetBindLogForwardDefault) WithStatusCode(code int) *GetBindLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get bind log forward default response
func (o *GetBindLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get bind log forward default response
func (o *GetBindLogForwardDefault) WithConfigurationVersion(configurationVersion string) *GetBindLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind log forward default response
func (o *GetBindLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind log forward default response
func (o *GetBindLogForwardDefault) WithPayload(payload *models.Error) *GetBindLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind log forward default response
func (o *GetBindLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
