/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.file;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.editors.file.IFileTypeHandler;
import org.jkiss.utils.CommonUtils;

public class FileTypeHandlerDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(FileTypeHandlerDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.ui.fileTypeHandler";
    private final String id;
    private final String[] extensions;
    private final AbstractDescriptor.ObjectType handlerType;
    private final int order;
    private boolean supportsRemote;

    public FileTypeHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.extensions = CommonUtils.notEmpty((String)config.getAttribute("extensions")).split(",");
        this.supportsRemote = CommonUtils.toBoolean((Object)config.getAttribute("remote"), (boolean)true);
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
    }

    public String getId() {
        return this.id;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean supportsRemoteFiles() {
        return this.supportsRemote;
    }

    public int getOrder() {
        return this.order;
    }

    public IFileTypeHandler createHandler() throws ReflectiveOperationException {
        Class clazz = this.handlerType.getObjectClass(IFileTypeHandler.class);
        if (clazz == null) {
            throw new NoClassDefFoundError(this.handlerType.getImplName());
        }
        return (IFileTypeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

