// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetClusterManagementTokenDetailsParams creates a new GetClusterManagementTokenDetailsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetClusterManagementTokenDetailsParams() *GetClusterManagementTokenDetailsParams {
	return &GetClusterManagementTokenDetailsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetClusterManagementTokenDetailsParamsWithTimeout creates a new GetClusterManagementTokenDetailsParams object
// with the ability to set a timeout on a request.
func NewGetClusterManagementTokenDetailsParamsWithTimeout(timeout time.Duration) *GetClusterManagementTokenDetailsParams {
	return &GetClusterManagementTokenDetailsParams{
		timeout: timeout,
	}
}

// NewGetClusterManagementTokenDetailsParamsWithContext creates a new GetClusterManagementTokenDetailsParams object
// with the ability to set a context for a request.
func NewGetClusterManagementTokenDetailsParamsWithContext(ctx context.Context) *GetClusterManagementTokenDetailsParams {
	return &GetClusterManagementTokenDetailsParams{
		Context: ctx,
	}
}

// NewGetClusterManagementTokenDetailsParamsWithHTTPClient creates a new GetClusterManagementTokenDetailsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetClusterManagementTokenDetailsParamsWithHTTPClient(client *http.Client) *GetClusterManagementTokenDetailsParams {
	return &GetClusterManagementTokenDetailsParams{
		HTTPClient: client,
	}
}

/*
GetClusterManagementTokenDetailsParams contains all the parameters to send to the API endpoint

	for the get cluster management token details operation.

	Typically these are written to a http.Request.
*/
type GetClusterManagementTokenDetailsParams struct {

	/* ID.

	   id is the user settable GNM cluster name
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get cluster management token details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterManagementTokenDetailsParams) WithDefaults() *GetClusterManagementTokenDetailsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get cluster management token details params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterManagementTokenDetailsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithTimeout(timeout time.Duration) *GetClusterManagementTokenDetailsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithContext(ctx context.Context) *GetClusterManagementTokenDetailsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithHTTPClient(client *http.Client) *GetClusterManagementTokenDetailsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithID(id string) *GetClusterManagementTokenDetailsParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithLocationOrganizationID(locationOrganizationID string) *GetClusterManagementTokenDetailsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithLocationProjectID(locationProjectID string) *GetClusterManagementTokenDetailsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithLocationRegionProvider(locationRegionProvider *string) *GetClusterManagementTokenDetailsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) WithLocationRegionRegion(locationRegionRegion *string) *GetClusterManagementTokenDetailsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get cluster management token details params
func (o *GetClusterManagementTokenDetailsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetClusterManagementTokenDetailsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
