package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindSerialNumber invokes the smartag.UnbindSerialNumber API synchronously
func (client *Client) UnbindSerialNumber(request *UnbindSerialNumberRequest) (response *UnbindSerialNumberResponse, err error) {
	response = CreateUnbindSerialNumberResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindSerialNumberWithChan invokes the smartag.UnbindSerialNumber API asynchronously
func (client *Client) UnbindSerialNumberWithChan(request *UnbindSerialNumberRequest) (<-chan *UnbindSerialNumberResponse, <-chan error) {
	responseChan := make(chan *UnbindSerialNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindSerialNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindSerialNumberWithCallback invokes the smartag.UnbindSerialNumber API asynchronously
func (client *Client) UnbindSerialNumberWithCallback(request *UnbindSerialNumberRequest, callback func(response *UnbindSerialNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindSerialNumberResponse
		var err error
		defer close(result)
		response, err = client.UnbindSerialNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindSerialNumberRequest is the request struct for api UnbindSerialNumber
type UnbindSerialNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// UnbindSerialNumberResponse is the response struct for api UnbindSerialNumber
type UnbindSerialNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindSerialNumberRequest creates a request to invoke UnbindSerialNumber API
func CreateUnbindSerialNumberRequest() (request *UnbindSerialNumberRequest) {
	request = &UnbindSerialNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "UnbindSerialNumber", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnbindSerialNumberResponse creates a response to parse from UnbindSerialNumber response
func CreateUnbindSerialNumberResponse() (response *UnbindSerialNumberResponse) {
	response = &UnbindSerialNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
