package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagRemoteAccess invokes the smartag.DescribeSagRemoteAccess API synchronously
func (client *Client) DescribeSagRemoteAccess(request *DescribeSagRemoteAccessRequest) (response *DescribeSagRemoteAccessResponse, err error) {
	response = CreateDescribeSagRemoteAccessResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagRemoteAccessWithChan invokes the smartag.DescribeSagRemoteAccess API asynchronously
func (client *Client) DescribeSagRemoteAccessWithChan(request *DescribeSagRemoteAccessRequest) (<-chan *DescribeSagRemoteAccessResponse, <-chan error) {
	responseChan := make(chan *DescribeSagRemoteAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagRemoteAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagRemoteAccessWithCallback invokes the smartag.DescribeSagRemoteAccess API asynchronously
func (client *Client) DescribeSagRemoteAccessWithCallback(request *DescribeSagRemoteAccessRequest, callback func(response *DescribeSagRemoteAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagRemoteAccessResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagRemoteAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagRemoteAccessRequest is the request struct for api DescribeSagRemoteAccess
type DescribeSagRemoteAccessRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeSagRemoteAccessResponse is the response struct for api DescribeSagRemoteAccess
type DescribeSagRemoteAccessResponse struct {
	*responses.BaseResponse
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	SmartAGId      string         `json:"SmartAGId" xml:"SmartAGId"`
	Code           string         `json:"Code" xml:"Code"`
	Success        bool           `json:"Success" xml:"Success"`
	RemoteAccesses RemoteAccesses `json:"RemoteAccesses" xml:"RemoteAccesses"`
}

// CreateDescribeSagRemoteAccessRequest creates a request to invoke DescribeSagRemoteAccess API
func CreateDescribeSagRemoteAccessRequest() (request *DescribeSagRemoteAccessRequest) {
	request = &DescribeSagRemoteAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagRemoteAccess", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagRemoteAccessResponse creates a response to parse from DescribeSagRemoteAccess response
func CreateDescribeSagRemoteAccessResponse() (response *DescribeSagRemoteAccessResponse) {
	response = &DescribeSagRemoteAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
