package lubancloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryGenerateTaskResult invokes the lubancloud.QueryGenerateTaskResult API synchronously
// api document: https://help.aliyun.com/api/lubancloud/querygeneratetaskresult.html
func (client *Client) QueryGenerateTaskResult(request *QueryGenerateTaskResultRequest) (response *QueryGenerateTaskResultResponse, err error) {
	response = CreateQueryGenerateTaskResultResponse()
	err = client.DoAction(request, response)
	return
}

// QueryGenerateTaskResultWithChan invokes the lubancloud.QueryGenerateTaskResult API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/querygeneratetaskresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryGenerateTaskResultWithChan(request *QueryGenerateTaskResultRequest) (<-chan *QueryGenerateTaskResultResponse, <-chan error) {
	responseChan := make(chan *QueryGenerateTaskResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryGenerateTaskResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryGenerateTaskResultWithCallback invokes the lubancloud.QueryGenerateTaskResult API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/querygeneratetaskresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryGenerateTaskResultWithCallback(request *QueryGenerateTaskResultRequest, callback func(response *QueryGenerateTaskResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryGenerateTaskResultResponse
		var err error
		defer close(result)
		response, err = client.QueryGenerateTaskResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryGenerateTaskResultRequest is the request struct for api QueryGenerateTaskResult
type QueryGenerateTaskResultRequest struct {
	*requests.RpcRequest
	TaskId requests.Integer `position:"Query" name:"TaskId"`
}

// QueryGenerateTaskResultResponse is the response struct for api QueryGenerateTaskResult
type QueryGenerateTaskResultResponse struct {
	*responses.BaseResponse
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	TotalSize   int       `json:"TotalSize" xml:"TotalSize"`
	WaitSize    int       `json:"WaitSize" xml:"WaitSize"`
	SuccessSize int       `json:"SuccessSize" xml:"SuccessSize"`
	FailSize    int       `json:"FailSize" xml:"FailSize"`
	Status      int       `json:"Status" xml:"Status"`
	Pictures    []Picture `json:"Pictures" xml:"Pictures"`
}

// CreateQueryGenerateTaskResultRequest creates a request to invoke QueryGenerateTaskResult API
func CreateQueryGenerateTaskResultRequest() (request *QueryGenerateTaskResultRequest) {
	request = &QueryGenerateTaskResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lubancloud", "2018-05-09", "QueryGenerateTaskResult", "luban", "openAPI")
	return
}

// CreateQueryGenerateTaskResultResponse creates a response to parse from QueryGenerateTaskResult response
func CreateQueryGenerateTaskResultResponse() (response *QueryGenerateTaskResultResponse) {
	response = &QueryGenerateTaskResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
