package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmsAuthTokens invokes the dypnsapi.GetSmsAuthTokens API synchronously
func (client *Client) GetSmsAuthTokens(request *GetSmsAuthTokensRequest) (response *GetSmsAuthTokensResponse, err error) {
	response = CreateGetSmsAuthTokensResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmsAuthTokensWithChan invokes the dypnsapi.GetSmsAuthTokens API asynchronously
func (client *Client) GetSmsAuthTokensWithChan(request *GetSmsAuthTokensRequest) (<-chan *GetSmsAuthTokensResponse, <-chan error) {
	responseChan := make(chan *GetSmsAuthTokensResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmsAuthTokens(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmsAuthTokensWithCallback invokes the dypnsapi.GetSmsAuthTokens API asynchronously
func (client *Client) GetSmsAuthTokensWithCallback(request *GetSmsAuthTokensRequest, callback func(response *GetSmsAuthTokensResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmsAuthTokensResponse
		var err error
		defer close(result)
		response, err = client.GetSmsAuthTokens(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmsAuthTokensRequest is the request struct for api GetSmsAuthTokens
type GetSmsAuthTokensRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductCode          string           `position:"Query" name:"ProductCode"`
	BundleId             string           `position:"Query" name:"BundleId"`
	SignName             string           `position:"Query" name:"SignName"`
	SceneCode            string           `position:"Query" name:"SceneCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	SmsCodeExpire        requests.Integer `position:"Query" name:"SmsCodeExpire"`
	PackageName          string           `position:"Query" name:"PackageName"`
	OsType               string           `position:"Query" name:"OsType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmsTemplateCode      string           `position:"Query" name:"SmsTemplateCode"`
	Expire               requests.Integer `position:"Query" name:"Expire"`
}

// GetSmsAuthTokensResponse is the response struct for api GetSmsAuthTokens
type GetSmsAuthTokensResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetSmsAuthTokensRequest creates a request to invoke GetSmsAuthTokens API
func CreateGetSmsAuthTokensRequest() (request *GetSmsAuthTokensRequest) {
	request = &GetSmsAuthTokensRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "GetSmsAuthTokens", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSmsAuthTokensResponse creates a response to parse from GetSmsAuthTokens response
func CreateGetSmsAuthTokensResponse() (response *GetSmsAuthTokensResponse) {
	response = &GetSmsAuthTokensResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
