package aQute.lib.bundle;
import java.util.*;

public class Resource implements Comparable {
	String			path;
	byte			bytes[];
	Jar				jar;
	boolean			web;

	static String[]	webExtensions	= {".html", ".gif", ".jpeg", ".jpg",
			".shtml", ".xml", ".png", ".css", ".js"};

	public boolean isMain() {
		return false;
	}
	public boolean isActivator() {
		return false;
	}
	public boolean isModified() {
		return false;
	}
	public boolean isWeb() {
		return web;
	}

	void checkWeb() {
		String name = getName().toLowerCase();

		for (int i = 0; i < webExtensions.length; i++) {
			if (name.endsWith(webExtensions[i])) {
				web = true;
				System.out.println("Is web resource " + path);
				return;
			}
		}
	}

	Resource(Jar jar, String path) {
		this.jar = jar;
		this.path = path;
		checkWeb();
	}

	String getPath() {
		return path;
	}

	String getPackageName() {
		int n = path.lastIndexOf('/');
		if (n < 0)
			n = 0;

		return path.substring(0, n).replace('/', '.');
	}

	String getName() {
		int n = path.lastIndexOf('/');
		return path.substring(n + 1);

	}

	public String getClassName() {
		throw new RuntimeException("Not a class");
	}

	public String getFQN() {
		return getPackageName() + "." + getClassName();
	}

	public void setBytes(byte[] bytes) {
		this.bytes = bytes;
	}

	public byte[] getBytes() {
		return bytes;
	}

	public boolean isReference() {
		return bytes == null;
	}

	public Set process() throws Exception {
		return null;
	}

	public int compareTo(Object o) {
		Resource r = (Resource) o;
		return getName().compareTo(r.getName());
	}

	public String toString() {
		return path;
	}
}

