package aQute.lib.version;

import java.util.regex.*;

public class VersionRange {
	Version			high;
	Version			low;
	char			start	= '[';
	char			end		= ']';

	static Pattern	RANGE	= Pattern.compile("(\\(|\\[)(" +
									Version.VERSION_STRING + "),(" +
									Version.VERSION_STRING + ")(\\)|\\])");

	public VersionRange(String string) {
		string = string.trim();
		Matcher m = RANGE.matcher(string);
		if (m.matches()) {
			start = m.group(1).charAt(0);
			low = new Version(m.group(2));
			high = new Version(m.group(6));
			end = m.group(10).charAt(0);
			if (low.compareTo(high) >= 0)
				throw new IllegalArgumentException(
						"Low Range is higher than High Range: " + low + "-" +
								high);

		} else
			high = low = new Version(string);
	}

	public boolean isRange() {
		return high != low;
	}

	public boolean includeLow() {
		return start == '[';
	}

	public boolean includeHigh() {
		return start == ']';
	}

	public String toString() {
		if (high == low)
			return high.toString();

		StringBuffer sb = new StringBuffer();
		sb.append(start);
		sb.append(low);
		sb.append(',');
		sb.append(high);
		sb.append(end);
		return sb.toString();
	}
}