/*
 * $Header: /cvs/xierpa/aQute.lib/src/aQute/lib/filterbuilder/F.java,v 1.1 2007-05-24 17:19:07 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2006). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.lib.filterbuilder;


//
// FilterBuilder fb = new FilterBuilder();
// f.and().eq(a,b).eq(a,b).or().toString();
public class F {

	public static FF and() {
		return new FF(null, FF.AND);
	}
	
	public static FF or() {
		return new FF(null,FF.OR);
	}
	
	public static FF not() {
		return new FF(null,FF.NOT);
	}
	
	
	public static String eq(String name, String value) {
		return   "(" + name + "=" + escape(value) + ")";
	}

	public static String eq(String name, int value) {
		return   "(" + name + "=" + value + ")";
	}

	public static String lte(String name, String value) {
		return   "(" + name + "<=" + escape(value) + ")";
	}

	public static String lte(String name, int value) {
		return   "(" + name + "<=" + value + ")";
	}

	public static String gte(String name, String value) {
		return   "(" + name + ">=" + escape(value) + ")";
	}

	public static String gte(String name, int value) {
		return   "(" + name + ">=" + value + ")";
	}

	public static String appr(String name, String value) {
		return   "(" + name + "~=" + escape(value) + ")";
	}

	public static String appr(String name, int value) {
		return   "(" + name + "~=" + value + ")";
	}

	public static String escape(String s ) {
		// TODO Do escaping of ) and others.
		return s;
	}
}
