/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Constants;
import org.jquantlib.math.UnaryFunctionDouble;

public abstract class AbstractSolver1D<F extends UnaryFunctionDouble> {
    private static final int MAX_FUNCTION_EVALUATIONS = 100;
    private int maxEvaluations_;
    private boolean lowerBoundEnforced_;
    private boolean upperBoundEnforced_;
    protected double root_;
    protected double xMin_;
    protected double xMax_;
    protected double fxMin_;
    protected double fxMax_;
    protected int evaluationNumber_;
    protected double lowerBound_;
    protected double upperBound_;

    public AbstractSolver1D() {
        this.maxEvaluations_ = 100;
        this.lowerBoundEnforced_ = false;
        this.upperBoundEnforced_ = false;
    }

    public AbstractSolver1D(int maxEvalautions, boolean lowerBoundEnforced, boolean upperBoundenforeced) {
        this.setMaxEvaluations(maxEvalautions);
        this.lowerBoundEnforced_ = lowerBoundEnforced;
        this.upperBoundEnforced_ = upperBoundenforeced;
    }

    protected abstract double solveImpl(F var1, double var2);

    public double solve(F f, double accuracy, double guess, double step) {
        if (!(accuracy > 0.0)) {
            throw new ArithmeticException("accuracy (" + accuracy + ") must be positive");
        }
        accuracy = Math.max(accuracy, Constants.QL_EPSILON);
        double growthFactor = 1.6;
        int flipflop = -1;
        this.root_ = guess;
        this.fxMax_ = f.evaluate(this.root_);
        if (this.fxMax_ == 0.0) {
            return this.root_;
        }
        if (this.fxMax_ > 0.0) {
            this.xMin_ = this.enforceBounds(this.root_ - step);
            this.fxMin_ = f.evaluate(this.xMin_);
            this.xMax_ = this.root_;
        } else {
            this.xMin_ = this.root_;
            this.fxMin_ = this.fxMax_;
            this.xMax_ = this.enforceBounds(this.root_ + step);
            this.fxMax_ = f.evaluate(this.xMax_);
        }
        this.evaluationNumber_ = 2;
        while (this.evaluationNumber_ <= this.maxEvaluations_) {
            if (this.fxMin_ * this.fxMax_ <= 0.0) {
                if (this.fxMin_ == 0.0) {
                    return this.xMin_;
                }
                if (this.fxMax_ == 0.0) {
                    return this.xMax_;
                }
                this.root_ = (this.xMax_ + this.xMin_) / 2.0;
                return this.solveImpl(f, accuracy);
            }
            if (Math.abs(this.fxMin_) < Math.abs(this.fxMax_)) {
                this.xMin_ = this.enforceBounds(this.xMin_ + 1.6 * (this.xMin_ - this.xMax_));
                this.fxMin_ = f.evaluate(this.xMin_);
            } else if (Math.abs(this.fxMin_) > Math.abs(this.fxMax_)) {
                this.xMax_ = this.enforceBounds(this.xMax_ + 1.6 * (this.xMax_ - this.xMin_));
                this.fxMax_ = f.evaluate(this.xMax_);
            } else if (flipflop == -1) {
                this.xMin_ = this.enforceBounds(this.xMin_ + 1.6 * (this.xMin_ - this.xMax_));
                this.fxMin_ = f.evaluate(this.xMin_);
                ++this.evaluationNumber_;
                flipflop = 1;
            } else if (flipflop == 1) {
                this.xMax_ = this.enforceBounds(this.xMax_ + 1.6 * (this.xMax_ - this.xMin_));
                this.fxMax_ = f.evaluate(this.xMax_);
                flipflop = -1;
            }
            ++this.evaluationNumber_;
        }
        throw new ArithmeticException("unable to bracket root in " + this.maxEvaluations_ + " function evaluations (last bracket attempt: " + "f[" + this.xMin_ + "," + this.xMax_ + "] " + "-> [" + this.fxMin_ + "," + this.fxMax_ + "])");
    }

    public double solve(F f, double accuracy, double guess, double xMin, double xMax) {
        if (!(accuracy > 0.0)) {
            throw new ArithmeticException("accuracy (" + accuracy + ") must be positive");
        }
        accuracy = Math.max(accuracy, Constants.QL_EPSILON);
        this.xMin_ = xMin;
        this.xMax_ = xMax;
        if (!(this.xMin_ < this.xMax_)) {
            throw new ArithmeticException("invalid range: xMin_ (" + this.xMin_ + ") >= xMax_ (" + this.xMax_ + ")");
        }
        if (this.lowerBoundEnforced_ && !(this.xMin_ >= this.lowerBound_)) {
            throw new ArithmeticException("xMin_ (" + this.xMin_ + ") < enforced low bound (" + this.lowerBound_ + ")");
        }
        if (this.upperBoundEnforced_ && !(this.xMax_ <= this.upperBound_)) {
            throw new ArithmeticException("xMax_ (" + this.xMax_ + ") > enforced hi bound (" + this.upperBound_ + ")");
        }
        this.fxMin_ = f.evaluate(this.xMin_);
        if (this.fxMin_ == 0.0) {
            return this.xMin_;
        }
        this.fxMax_ = f.evaluate(this.xMax_);
        if (this.fxMax_ == 0.0) {
            return this.xMax_;
        }
        this.evaluationNumber_ = 2;
        if (!(this.fxMin_ * this.fxMax_ < 0.0)) {
            throw new ArithmeticException("root not bracketed: f[" + this.xMin_ + "," + this.xMax_ + "] -> [" + this.fxMin_ + "," + this.fxMax_ + "]");
        }
        if (!(guess > this.xMin_)) {
            throw new ArithmeticException("guess (" + guess + ") < xMin_ (" + this.xMin_ + ")");
        }
        if (!(guess < this.xMax_)) {
            throw new ArithmeticException("guess (" + guess + ") > xMax_ (" + this.xMax_ + ")");
        }
        this.root_ = guess;
        return this.solveImpl(f, accuracy);
    }

    public void setMaxEvaluations(int evaluations) {
        this.maxEvaluations_ = Math.max(1, evaluations);
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations_;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound_ = lowerBound;
        this.lowerBoundEnforced_ = true;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound_ = upperBound;
        this.upperBoundEnforced_ = true;
    }

    public int getNumEvaluations() {
        return this.evaluationNumber_;
    }

    private double enforceBounds(double x) {
        if (this.lowerBoundEnforced_ && x < this.lowerBound_) {
            return this.lowerBound_;
        }
        if (this.upperBoundEnforced_ && x > this.upperBound_) {
            return this.upperBound_;
        }
        return x;
    }
}

