/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.UnaryFunctionDouble;

public class Bisection
extends AbstractSolver1D<UnaryFunctionDouble> {
    @Override
    protected double solveImpl(UnaryFunctionDouble f, double xAccuracy) {
        double dx;
        if (this.fxMin_ < 0.0) {
            dx = this.xMax_ - this.xMin_;
            this.root_ = this.xMin_;
        } else {
            dx = this.xMin_ - this.xMax_;
            this.root_ = this.xMax_;
        }
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            double xMid = this.root_ + (dx /= 2.0);
            double fMid = f.evaluate(xMid);
            ++this.evaluationNumber_;
            if (fMid <= 0.0) {
                this.root_ = xMid;
            }
            if (!(Math.abs(dx) < xAccuracy) && fMid != 0.0) continue;
            return this.root_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }
}

