/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import java.util.Arrays;
import org.jquantlib.util.stdlibc.DoubleForwardIterator;
import org.jquantlib.util.stdlibc.DoubleReference;
import org.jquantlib.util.stdlibc.DoubleReverseIterator;
import org.jquantlib.util.stdlibc.MutableDoubleForwardIterator;
import org.jquantlib.util.stdlibc.MutableDoubleReverseIterator;
import org.jquantlib.util.stdlibc.Std;

public class Array {
    private double[] data;

    public Array() {
        this(0);
    }

    public Array(int size) {
        this.data = new double[size];
    }

    public Array(int size, double value) {
        this(size);
        for (int i = 0; i < size; ++i) {
            this.data[i] = value;
        }
    }

    public double[] getData() {
        return this.data;
    }

    public Array(int size, double value, double increment) {
        this(size);
        if (size > 0) {
            this.data[0] = value;
        }
        for (int i = 1; i < size; ++i) {
            this.data[i] = this.data[i - 1] + increment;
        }
    }

    public Array(double[] d) {
        this.data = d;
    }

    public Array(Array oldArray) {
        double[] copy = new double[oldArray.getData().length];
        System.arraycopy(oldArray.getData(), 0, copy, 0, oldArray.getData().length);
        this.data = copy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Arrays.toString(this.data));
        return sb.toString();
    }

    public static double dotProduct(Array vectorA, Array vectorB) {
        return Array.dotProduct(vectorA.data, vectorB.data);
    }

    public static double dotProduct(double[] vectorA, double[] vectorB) {
        if (vectorA != null && vectorB != null && vectorA.length == vectorB.length) {
            return Array.quickDotProduct(vectorA, vectorB);
        }
        throw new RuntimeException("VectorA and VectorB must both be non-null and the same length.");
    }

    public boolean operatorNotEquals(Array paramArray) {
        return !this.operatorEquals(paramArray);
    }

    public boolean operatorEquals(Array paramArray) {
        if (this.data == null || paramArray == null || paramArray.data == null) {
            return false;
        }
        if (this.data.length != paramArray.data.length) {
            return false;
        }
        return this.operatorEquals(paramArray.data);
    }

    public boolean operatorEquals(double[] paramData) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == paramData[i]) continue;
            return false;
        }
        return true;
    }

    public void operatorDivide(double scale) {
        this.data = Array.quickOperatorDivideReplace(this.data, scale);
    }

    public void operatorMultiply(double scale) {
        this.data = Array.quickOperatorMultiplyReplace(this.data, scale);
    }

    public void operatorSubtract(double scale) {
        this.data = Array.quickOperatorSubtractReplace(this.data, scale);
    }

    public void operatorAdd(double scale) {
        this.data = Array.quickOperatorAddReplace(this.data, scale);
    }

    public void operatorDivide(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        this.data = Array.quickOperatorDivideReplace(this.data, paramArray.data);
    }

    public void operatorMultiply(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        this.data = Array.quickOperatorMultiplyReplace(this.data, paramArray.data);
    }

    public void operatorSubtract(Array paramArray) throws Exception {
        this.vectorOperationValidation(paramArray);
        this.data = Array.quickOperatorSubtractReplace(this.data, paramArray.data);
    }

    public void operatorAdd(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        this.data = Array.quickOperatorAddReplace(this.data, paramArray.data);
    }

    public Array operatorDivideCopy(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        return this.quickOperatorDivideCopy(paramArray);
    }

    public Array operatorMultiplyCopy(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        return this.quickOperatorMultiplyCopy(paramArray);
    }

    public Array operatorSubtractCopy(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        return this.quickOperatorSubtractCopy(paramArray);
    }

    public Array operatorAddCopy(Array paramArray) {
        this.vectorOperationValidation(paramArray);
        return this.quickOperatorAddCopy(paramArray);
    }

    public boolean empty() {
        return this.data.length == 0;
    }

    public int size() {
        return this.data.length;
    }

    public void set(int index, double value) {
        if (this.data.length <= index) {
            throw new RuntimeException("Illegal Argument, index must be less than the Array size.");
        }
        this.data[index] = value;
    }

    public static void swap(Array vectorA, Array vectorB) {
        Array.vectorOperationValidation(vectorA, vectorB);
        double[] dataA = vectorA.data;
        double[] dataB = vectorB.data;
        for (int i = 0; i < dataA.length; ++i) {
            double storage = dataA[i];
            dataA[i] = dataB[i];
            dataB[i] = storage;
        }
    }

    public static void shallowSwap(Array vectorA, Array vectorB) {
        double[] swapArray = vectorA.data;
        vectorA.data = vectorB.data;
        vectorB.data = swapArray;
    }

    public void swap(Array paramVector) {
        Array.swap(this, paramVector);
    }

    public void shallowSwap(Array paramVector) {
        Array.shallowSwap(this, paramVector);
    }

    public Array absCopy() {
        double[] da = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            da[i] = Math.abs(this.data[i]);
        }
        return new Array(da);
    }

    public void abs() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.abs(this.data[i]);
        }
    }

    public Array sqrtCopy() {
        double[] da = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            da[i] = Math.sqrt(this.data[i]);
        }
        return new Array(da);
    }

    public void sqrt() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.sqrt(this.data[i]);
        }
    }

    public Array logCopy() {
        double[] da = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            da[i] = Math.log(this.data[i]);
        }
        return new Array(da);
    }

    public void log() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.log(this.data[i]);
        }
    }

    public Array expCopy() {
        double[] da = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            da[i] = Math.exp(this.data[i]);
        }
        return new Array(da);
    }

    public void exp() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.exp(this.data[i]);
        }
    }

    public DoubleForwardIterator forwardIterator() {
        return Std.forwardIterator(this.data);
    }

    public MutableDoubleForwardIterator mutableForwardIterator() {
        return Std.mutableForwardIterator(this.data);
    }

    public DoubleReverseIterator reverseIterator() {
        return Std.reverseIterator(this.data);
    }

    public MutableDoubleReverseIterator mutableReverseIterator() {
        return Std.mutableReverseIterator(this.data);
    }

    public double get(int i) {
        this.validateData(i);
        return this.data[i];
    }

    public double at(int i) {
        return this.get(i);
    }

    public double front() {
        return this.get(0);
    }

    public double back() {
        return this.get(this.data.length - 1);
    }

    public DoubleReference getReference(int i) {
        this.validateData(i);
        return new DoubleReference(this.data, i);
    }

    public DoubleReference atReference(int i) {
        this.validateData(i);
        return new DoubleReference(this.data, i);
    }

    public DoubleReference frontReference() {
        this.validateData(0);
        return new DoubleReference(this.data, 0);
    }

    public DoubleReference backReference() {
        this.validateData(this.data.length - 1);
        return new DoubleReference(this.data, this.data.length - 1);
    }

    private void quickOperatorDivide(Array paramArray) {
        this.data = Array.quickOperatorDivideReplace(this.data, paramArray.data);
    }

    private void quickOperatorMultiply(Array paramArray) {
        this.data = Array.quickOperatorMultiplyReplace(this.data, paramArray.data);
    }

    private void quickOperatorSubtract(Array paramArray) {
        this.data = Array.quickOperatorSubtractReplace(this.data, paramArray.data);
    }

    private void quickOperatorAdd(Array paramArray) {
        this.data = Array.quickOperatorAddReplace(this.data, paramArray.data);
    }

    private Array quickOperatorDivideCopy(Array paramArray) {
        double[] dataCopy = Array.quickOperatorDivide(this.data, paramArray.data);
        return new Array(dataCopy);
    }

    private Array quickOperatorMultiplyCopy(Array paramArray) {
        double[] dataCopy = Array.quickOperatorMultiply(this.data, paramArray.data);
        return new Array(dataCopy);
    }

    private Array quickOperatorSubtractCopy(Array paramArray) {
        double[] dataCopy = Array.quickOperatorSubtract(this.data, paramArray.data);
        return new Array(dataCopy);
    }

    private Array quickOperatorAddCopy(Array paramArray) {
        double[] dataCopy = Array.quickOperatorAdd(this.data, paramArray.data);
        return new Array(dataCopy);
    }

    private void validateData(int s) {
        if (this.data == null || this.data.length < s + 1) {
            throw new RuntimeException("data is not properly conditioned.");
        }
    }

    private void quickSwap(Array paramVector) {
        Array.quickSwap(this, paramVector);
    }

    private void vectorOperationValidation(Array paramArray) {
        if (this.data == null) {
            throw new RuntimeException("the underlying array must not be null");
        }
        if (paramArray == null) {
            throw new RuntimeException("the param array must not be null");
        }
        if (paramArray.data == null) {
            throw new RuntimeException("the param array's underlying must not be null");
        }
        if (this.data.length != paramArray.data.length) {
            throw new RuntimeException("the two arrays must be the same length");
        }
    }

    private static void vectorOperationValidation(Array vectorA, Array vectorB) {
        if (vectorA != null) {
            vectorA.vectorOperationValidation(vectorB);
        }
    }

    private static double[] quickOperatorAdd(double[] vectorA, double[] vectorB) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] + vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorSubtract(double[] vectorA, double[] vectorB) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] - vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorMultiply(double[] vectorA, double[] vectorB) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] * vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorDivide(double[] vectorA, double[] vectorB) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] / vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorAdd(double[] vectorA, double scale) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] + scale;
        }
        return outputData;
    }

    private static double[] quickOperatorSubtract(double[] vectorA, double scale) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] - scale;
        }
        return outputData;
    }

    private static double[] quickOperatorMultiply(double[] vectorA, double scale) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] * scale;
        }
        return outputData;
    }

    private static double[] quickOperatorDivide(double[] vectorA, double scale) {
        double[] outputData = new double[vectorA.length];
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] / scale;
        }
        return outputData;
    }

    private static double[] quickOperatorAddReplace(double[] vectorA, double[] vectorB) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] + vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorSubtractReplace(double[] vectorA, double[] vectorB) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] - vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorMultiplyReplace(double[] vectorA, double[] vectorB) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] * vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorDivideReplace(double[] vectorA, double[] vectorB) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] / vectorB[i];
        }
        return outputData;
    }

    private static double[] quickOperatorAddReplace(double[] vectorA, double scale) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] + scale;
        }
        return outputData;
    }

    private static double[] quickOperatorSubtractReplace(double[] vectorA, double scale) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] - scale;
        }
        return outputData;
    }

    private static double[] quickOperatorMultiplyReplace(double[] vectorA, double scale) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] * scale;
        }
        return outputData;
    }

    private static double[] quickOperatorDivideReplace(double[] vectorA, double scale) {
        double[] outputData = vectorA;
        for (int i = 0; i < vectorA.length; ++i) {
            outputData[i] = vectorA[i] / scale;
        }
        return outputData;
    }

    private static double quickDotProduct(double[] vectorA, double[] vectorB) {
        double result = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            result += vectorA[i] * vectorB[i];
        }
        return result;
    }

    private static double quickDotProduct(Array vectorA, Array vectorB) {
        return Array.quickDotProduct(vectorA.data, vectorB.data);
    }

    private static void quickSwap(Array vectorA, Array vectorB) {
        double[] swapArray = new double[vectorA.data.length];
        System.arraycopy(vectorA.data, 0, swapArray, 0, vectorA.data.length);
        System.arraycopy(vectorB.data, 0, vectorA.data, 0, vectorB.data.length);
        System.arraycopy(swapArray, 0, vectorB.data, 0, swapArray.length);
    }
}

