/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.dto.RequestInfoDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.RuntimeDTOBuilder;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;

public final class HttpServiceRuntimeImpl
implements HttpServiceRuntime {
    private static final String PROP_CHANGECOUNT = "service.changecount";
    private static final String PROP_CHANGECOUNTDELAY = "org.apache.felix.http.whiteboard.changecount.delay";
    private volatile Hashtable<String, Object> attributes = new Hashtable();
    private final HandlerRegistry registry;
    private final WhiteboardManager contextManager;
    private volatile long changeCount;
    private volatile ServiceRegistration<HttpServiceRuntime> serviceReg;
    private volatile ServiceReferenceDTO serviceRefDTO;
    private volatile Timer timer;
    private final long updateChangeCountDelay;

    public HttpServiceRuntimeImpl(HandlerRegistry registry, WhiteboardManager contextManager, BundleContext bundleContext) {
        this.registry = registry;
        this.contextManager = contextManager;
        String val = bundleContext.getProperty(PROP_CHANGECOUNTDELAY);
        long value = 2000L;
        if (val != null) {
            try {
                value = Long.parseLong(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value < 1L) {
                value = 0L;
            }
        }
        this.updateChangeCountDelay = value;
    }

    @Override
    public RuntimeDTO getRuntimeDTO() {
        ServiceRegistration<HttpServiceRuntime> reg;
        if (this.serviceRefDTO == null && (reg = this.serviceReg) != null) {
            ServiceReferenceDTO[] dtos;
            long id = (Long)reg.getReference().getProperty("service.id");
            for (ServiceReferenceDTO dto : dtos = (ServiceReferenceDTO[])reg.getReference().getBundle().adapt(ServiceReferenceDTO[].class)) {
                if (dto.id != id) continue;
                this.serviceRefDTO = dto;
                break;
            }
        }
        if (this.serviceRefDTO != null) {
            RuntimeDTOBuilder runtimeDTOBuilder = new RuntimeDTOBuilder(this.contextManager.getRuntimeInfo(), this.serviceRefDTO);
            return runtimeDTOBuilder.build();
        }
        throw new IllegalStateException("Service is already unregistered");
    }

    @Override
    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        return new RequestInfoDTOBuilder(this.registry, path).build();
    }

    public synchronized void setAttribute(String name, Object value) {
        Hashtable<String, Object> newAttributes = new Hashtable<String, Object>(this.attributes);
        newAttributes.put(name, value);
        this.attributes = newAttributes;
    }

    public synchronized void setAllAttributes(Dictionary<String, Object> newAttributes) {
        Hashtable<String, Object> replacement = new Hashtable<String, Object>();
        for (String key : Collections.list(newAttributes.keys())) {
            replacement.put(key, newAttributes.get(key));
        }
        replacement.put(PROP_CHANGECOUNT, this.changeCount);
        this.attributes = replacement;
    }

    public void register(BundleContext bundleContext) {
        this.serviceReg = bundleContext.registerService(HttpServiceRuntime.class, (Object)this, this.attributes);
    }

    public void unregister() {
        if (this.serviceReg != null) {
            try {
                this.serviceReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.serviceReg = null;
        }
        this.serviceRefDTO = null;
    }

    public ServiceReference<HttpServiceRuntime> getServiceReference() {
        ServiceRegistration<HttpServiceRuntime> reg = this.serviceReg;
        if (reg != null) {
            return reg.getReference();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChangeCount() {
        final ServiceRegistration<HttpServiceRuntime> reg = this.serviceReg;
        if (reg != null) {
            boolean setPropsDirectly = false;
            HttpServiceRuntimeImpl httpServiceRuntimeImpl = this;
            synchronized (httpServiceRuntimeImpl) {
                ++this.changeCount;
                final long count = this.changeCount;
                this.setAttribute(PROP_CHANGECOUNT, this.changeCount);
                if (this.updateChangeCountDelay <= 0L) {
                    setPropsDirectly = true;
                } else {
                    if (this.timer == null) {
                        this.timer = new Timer();
                    }
                    this.timer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HttpServiceRuntimeImpl httpServiceRuntimeImpl = HttpServiceRuntimeImpl.this;
                            synchronized (httpServiceRuntimeImpl) {
                                if (HttpServiceRuntimeImpl.this.changeCount == count) {
                                    try {
                                        reg.setProperties((Dictionary)HttpServiceRuntimeImpl.this.attributes);
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        // empty catch block
                                    }
                                    HttpServiceRuntimeImpl.this.timer.cancel();
                                    HttpServiceRuntimeImpl.this.timer = null;
                                }
                            }
                        }
                    }, this.updateChangeCountDelay);
                }
            }
            if (setPropsDirectly) {
                try {
                    reg.setProperties(this.attributes);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

