/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.util.List;
import java.util.Vector;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.Array;
import org.jquantlib.math.SampledCurve;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.NeumannBC;
import org.jquantlib.methods.finitedifferences.OperatorFactory;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;
import org.jquantlib.pricingengines.arguments.Arguments;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.Results;
import org.jquantlib.pricingengines.vanilla.finitedifferences.PayoffFunction;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.util.Date;

public class FDVanillaEngine {
    protected GeneralizedBlackScholesProcess process;
    protected int timeSteps;
    protected int gridPoints;
    protected boolean timeDependent;
    protected double requiredGridValue;
    protected Date exerciseDate;
    protected Payoff payoff;
    protected TridiagonalOperator finiteDifferenceOperator;
    protected SampledCurve intrinsicValues;
    protected List<BoundaryCondition<TridiagonalOperator>> bcS;
    protected double sMin;
    protected double center;
    protected double sMax;
    public static final double safetyZoneFactor = 1.1;

    public FDVanillaEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.process = process;
        this.timeSteps = timeSteps;
        this.gridPoints = gridPoints;
        this.timeDependent = timeDependent;
        this.intrinsicValues = new SampledCurve(gridPoints);
        this.bcS = new Vector<BoundaryCondition<TridiagonalOperator>>();
    }

    public Array grid() {
        return this.intrinsicValues.grid();
    }

    protected void setGridLimits() {
        this.setGridLimits(this.process.stateVariable().getLink().evaluate(), this.getResidualTime());
        this.ensureStrikeInGrid();
    }

    protected void setupArguments(Arguments a) {
        OneAssetOptionArguments args = (OneAssetOptionArguments)a;
        this.exerciseDate = args.exercise.lastDate();
        this.payoff = args.payoff;
        this.requiredGridValue = ((StrikedTypePayoff)this.payoff).strike();
    }

    protected void setGridLimits(double center, double t) {
        if (center <= 0.0) {
            throw new IllegalStateException("negative or null underlying given");
        }
        this.center = center;
        int newGridPoints = this.safeGridPoints(this.gridPoints, t);
        if (newGridPoints > this.intrinsicValues.size()) {
            this.intrinsicValues = new SampledCurve(newGridPoints);
        }
        double volSqrtTime = Math.sqrt(this.process.blackVolatility().getLink().blackVariance(t, center));
        double prefactor = 1.0 + 0.02 / volSqrtTime;
        double minMaxFactor = Math.exp(4.0 * prefactor * volSqrtTime);
        this.sMin = center / minMaxFactor;
        this.sMax = center * minMaxFactor;
    }

    protected void ensureStrikeInGrid() {
        StrikedTypePayoff striked_payoff = (StrikedTypePayoff)this.payoff;
        if (striked_payoff == null) {
            return;
        }
        double requiredGridValue = striked_payoff.strike();
        if (this.sMin > requiredGridValue / 1.1) {
            this.sMin = requiredGridValue / 1.1;
            this.sMax = this.center / (this.sMin / this.center);
        }
        if (this.sMax < requiredGridValue * 1.1) {
            this.sMax = requiredGridValue * 1.1;
            this.sMin = this.center / (this.sMax / this.center);
        }
    }

    protected void initializeInitialCondition() {
        this.intrinsicValues.setLogGrid(this.sMin, this.sMax);
        PayoffFunction function = new PayoffFunction(this.payoff);
        this.intrinsicValues.sample(function);
    }

    protected void initializeOperator() {
        this.finiteDifferenceOperator = OperatorFactory.getOperator(this.process, this.intrinsicValues.grid(), this.getResidualTime(), this.timeDependent);
    }

    protected void initializeBoundaryConditions() {
        this.bcS.add(new NeumannBC(this.intrinsicValues.value(1) - this.intrinsicValues.value(0), BoundaryCondition.Side.LOWER));
        this.bcS.add(new NeumannBC(this.intrinsicValues.value(this.intrinsicValues.size() - 1) - this.intrinsicValues.value(this.intrinsicValues.size() - 2), BoundaryCondition.Side.UPPER));
    }

    protected double getResidualTime() {
        return this.process.getTime(this.exerciseDate);
    }

    protected int safeGridPoints(int gridPoints, double residualTime) {
        int minGridPoints = 10;
        int minGridPointsPerYear = 2;
        return Math.max(gridPoints, residualTime > 1.0 ? (int)(10.0 + (residualTime - 1.0) * 2.0) : 10);
    }

    protected void calculate(Results r) {
    }
}

