/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.impl.bundle.obr.resource.CapabilityImpl;
import org.osgi.impl.bundle.obr.resource.Manifest;
import org.osgi.impl.bundle.obr.resource.ManifestEntry;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.RequirementImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.VersionRange;

public class BundleInfo {
    Manifest manifest;
    File bundleJar;
    ZipFile jar;
    String license;
    Properties localization;
    RepositoryImpl repository;

    public BundleInfo(RepositoryImpl repository, File bundleJar) throws Exception {
        this.bundleJar = bundleJar;
        this.repository = repository;
        if (!this.bundleJar.exists()) {
            throw new FileNotFoundException(bundleJar.toString());
        }
        this.jar = new ZipFile(bundleJar);
        ZipEntry entry = this.jar.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            throw new FileNotFoundException("No Manifest in " + bundleJar.toString());
        }
        this.manifest = new Manifest(this.jar.getInputStream(entry));
    }

    public BundleInfo(Manifest manifest) throws Exception {
        this.manifest = manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceImpl build() throws Exception {
        ResourceImpl resource = new ResourceImpl(this.repository, this.manifest.getSymbolicName(), this.manifest.getVersion());
        try {
            URL location = new URL("jar:" + this.bundleJar.toURL().toString() + "!/");
            resource.setURL(this.bundleJar.toURL());
            resource.setFile(this.bundleJar);
            this.doReferences(resource, location);
            this.doSize(resource);
            this.doCategories(resource);
            this.doImportExportServices(resource);
            this.doDeclarativeServices(resource);
            this.doFragment(resource);
            this.doRequires(resource);
            this.doBundle(resource);
            this.doExports(resource);
            this.doImports(resource);
            this.doExecutionEnvironment(resource);
            ResourceImpl resourceImpl = resource;
            return resourceImpl;
        }
        finally {
            try {
                this.jar.close();
            }
            catch (Exception e) {}
        }
    }

    void doSize(ResourceImpl resource) {
        long size = this.bundleJar.length();
        if (size > 0L) {
            resource.setSize(size);
        }
    }

    void doCategories(ResourceImpl resource) {
        for (int i = 0; i < this.manifest.getCategories().length; ++i) {
            String category = this.manifest.getCategories()[i];
            resource.addCategory(category);
        }
    }

    void doReferences(ResourceImpl resource, URL location) {
        String source;
        String documentation;
        String copyright;
        String license;
        String name = this.translated("Bundle-Name");
        if (name != null) {
            resource.setPresentationName(name);
        }
        if ((license = this.translated("Bundle-License")) != null) {
            resource.setLicense(this.toURL(location, license));
        } else if (this.license != null) {
            resource.setLicense(this.toURL(location, this.license));
        }
        String description = this.translated("Bundle-Description");
        if (description != null) {
            resource.setDescription(description);
        }
        if ((copyright = this.translated("Bundle-Copyright")) != null) {
            resource.setCopyright(copyright);
        }
        if ((documentation = this.translated("Bundle-DocURL")) != null) {
            resource.setDocumentation(this.toURL(location, documentation));
        }
        if ((source = this.manifest.getValue("Bundle-Source")) != null) {
            resource.setSource(this.toURL(location, source));
        }
    }

    URL toURL(URL location, String source) {
        try {
            return new URL(location, source);
        }
        catch (Exception e) {
            System.err.println("Error in converting url: " + location + " : " + source);
            return null;
        }
    }

    void doDeclarativeServices(ResourceImpl resource) throws Exception {
        int i;
        String serviceComponent = this.manifest.getValue("service-component");
        if (serviceComponent == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(serviceComponent, " ,\t");
        String[] parts = new String[st.countTokens()];
        for (i = 0; i < parts.length; ++i) {
            parts[i] = st.nextToken();
        }
        for (i = 0; i < parts.length; ++i) {
            ZipEntry entry = this.jar.getEntry(parts[i]);
            if (entry == null) {
                System.err.println("Bad Service-Component header: " + serviceComponent + ", no such file " + parts[i]);
            }
            InputStream in = this.jar.getInputStream(entry);
            in.close();
        }
    }

    void doImportExportServices(ResourceImpl resource) throws IOException {
        String exportServices;
        String importServices = this.manifest.getValue("import-service");
        if (importServices != null) {
            List entries = this.manifest.getEntries(importServices);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                ManifestEntry entry = (ManifestEntry)i.next();
                RequirementImpl ri = new RequirementImpl("service");
                ri.setFilter(this.createServiceFilter(entry));
                ri.setComment("Import Service " + entry.getName());
                ri.setOptional(false);
                ri.setMultiple(true);
                resource.addRequirement(ri);
            }
        }
        if ((exportServices = this.manifest.getValue("export-service")) != null) {
            List entries = this.manifest.getEntries(exportServices);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                ManifestEntry entry = (ManifestEntry)i.next();
                CapabilityImpl cap = this.createServiceCapability(entry);
                resource.addCapability(cap);
            }
        }
    }

    String translated(String key) {
        return this.translate(this.manifest.getValue(key));
    }

    void doFragment(ResourceImpl resource) {
        ManifestEntry entry = this.manifest.getHost();
        if (entry == null) {
            return;
        }
        RequirementImpl r = new RequirementImpl("bundle");
        StringBuffer sb = new StringBuffer();
        sb.append("(&(symbolicname=");
        sb.append(entry.getName());
        sb.append(")(version>=");
        sb.append(entry.getVersion());
        sb.append("))");
        r.setFilter(sb.toString());
        r.setComment("Required Host " + entry.getName());
        r.setExtend(true);
        r.setOptional(false);
        r.setMultiple(false);
        resource.addRequirement(r);
        CapabilityImpl capability = new CapabilityImpl("fragment");
        capability.addProperty("host", entry.getName());
        capability.addProperty("version", entry.getVersion());
        resource.addCapability(capability);
    }

    void doRequires(ResourceImpl resource) {
        List entries = this.manifest.getRequire();
        if (entries == null) {
            return;
        }
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ManifestEntry entry = (ManifestEntry)i.next();
            RequirementImpl r = new RequirementImpl("bundle");
            StringBuffer sb = new StringBuffer();
            sb.append("(&(symbolicname=");
            sb.append(entry.getName());
            sb.append(")(version>=");
            sb.append(entry.getVersion());
            sb.append("))");
            r.setFilter(sb.toString());
            r.setComment("Require Bundle " + entry.getName() + "; " + entry.getVersion());
            if (entry.directives == null || "true".equalsIgnoreCase((String)entry.directives.get("resolution"))) {
                r.setOptional(false);
            } else {
                r.setOptional(true);
            }
            resource.addRequirement(r);
        }
    }

    void doExecutionEnvironment(ResourceImpl resource) {
        String[] parts = this.manifest.getRequiredExecutionEnvironments();
        if (parts == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(|");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append("(ee=");
            sb.append(part);
            sb.append(")");
        }
        sb.append(")");
        RequirementImpl req = new RequirementImpl("ee");
        req.setFilter(sb.toString());
        req.setComment("Execution Environment " + sb.toString());
        resource.addRequirement(req);
    }

    void doImports(ResourceImpl resource) {
        ArrayList<RequirementImpl> requirements = new ArrayList<RequirementImpl>();
        List packages = this.manifest.getImports();
        if (packages == null) {
            return;
        }
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            ManifestEntry pack = (ManifestEntry)i.next();
            RequirementImpl requirement = new RequirementImpl("package");
            this.createImportFilter(requirement, "package", pack);
            requirement.setComment("Import package " + pack);
            requirements.add(requirement);
        }
        i = requirements.iterator();
        while (i.hasNext()) {
            resource.addRequirement((RequirementImpl)i.next());
        }
    }

    String createServiceFilter(ManifestEntry pack) {
        StringBuffer filter = new StringBuffer();
        filter.append("(service=");
        filter.append(pack.getName());
        filter.append(")");
        return filter.toString();
    }

    void createImportFilter(RequirementImpl req, String name, ManifestEntry pack) {
        Map attributes;
        Set attrs;
        StringBuffer filter = new StringBuffer();
        filter.append("(&(");
        filter.append(name);
        filter.append("=");
        filter.append(pack.getName());
        filter.append(")");
        VersionRange version = pack.getVersion();
        if (version != null) {
            if (version.isRange()) {
                filter.append("(version");
                filter.append(">");
                if (version.includeLow()) {
                    filter.append("=");
                }
                filter.append(version.low);
                filter.append(")");
                filter.append("(version");
                filter.append("<");
                if (version.includeHigh()) {
                    filter.append("=");
                }
                filter.append(version.high);
                filter.append(")");
            } else {
                filter.append("(version>=");
                filter.append(pack.getVersion());
                filter.append(")");
            }
        }
        if ((attrs = this.doImportPackageAttributes(req, filter, attributes = pack.getAttributes())).size() > 0) {
            String del = "";
            filter.append("(mandatory:<*");
            Iterator i = attrs.iterator();
            while (i.hasNext()) {
                filter.append(del);
                filter.append(i.next());
                del = ", ";
            }
            filter.append(")");
        }
        filter.append(")");
        req.setFilter(filter.toString());
    }

    Set doImportPackageAttributes(RequirementImpl req, StringBuffer filter, Map attributes) {
        HashSet<String> set = new HashSet<String>();
        if (attributes != null) {
            Iterator i = attributes.keySet().iterator();
            while (i.hasNext()) {
                String attribute = (String)i.next();
                String value = (String)attributes.get(attribute);
                if (attribute.equalsIgnoreCase("specification-version") || attribute.equalsIgnoreCase("version")) continue;
                if (attribute.equalsIgnoreCase("resolution:")) {
                    req.setOptional(value.equalsIgnoreCase("optional"));
                }
                if (attribute.endsWith(":")) continue;
                filter.append("(");
                filter.append(attribute);
                filter.append("=");
                filter.append(attributes.get(attribute));
                filter.append(")");
                set.add(attribute);
            }
        }
        return set;
    }

    void doBundle(ResourceImpl resource) {
        CapabilityImpl capability = new CapabilityImpl("bundle");
        capability.addProperty("symbolicname", this.manifest.getSymbolicName());
        if (this.manifest.getValue("Bundle-Name") != null) {
            capability.addProperty("presentationname", this.translated("Bundle-Name"));
        }
        capability.addProperty("version", this.manifest.getVersion());
        capability.addProperty("manifestversion", this.manifest.getManifestVersion());
        ManifestEntry host = this.manifest.getHost();
        if (host != null) {
            capability.addProperty("host", host.getName());
            if (host.getVersion() != null) {
                capability.addProperty("version", host.getVersion());
            }
        }
        resource.addCapability(capability);
    }

    void doExports(ResourceImpl resource) {
        Iterator i;
        ArrayList<CapabilityImpl> capabilities = new ArrayList<CapabilityImpl>();
        List packages = this.manifest.getExports();
        if (packages != null) {
            i = packages.iterator();
            while (i.hasNext()) {
                ManifestEntry pack = (ManifestEntry)i.next();
                CapabilityImpl capability = this.createCapability("package", pack);
                capabilities.add(capability);
            }
        }
        i = capabilities.iterator();
        while (i.hasNext()) {
            resource.addCapability((CapabilityImpl)i.next());
        }
    }

    CapabilityImpl createServiceCapability(ManifestEntry pack) {
        CapabilityImpl capability = new CapabilityImpl("service");
        capability.addProperty("service", pack.getName());
        return capability;
    }

    CapabilityImpl createCapability(String name, ManifestEntry pack) {
        CapabilityImpl capability = new CapabilityImpl(name);
        capability.addProperty(name, pack.getName());
        capability.addProperty("version", pack.getVersion());
        Map attributes = pack.getAttributes();
        if (attributes != null) {
            Iterator at = attributes.keySet().iterator();
            while (at.hasNext()) {
                String key = (String)at.next();
                if (key.equalsIgnoreCase("specification-version") || key.equalsIgnoreCase("version")) continue;
                Object value = attributes.get(key);
                capability.addProperty(key, value);
            }
        }
        return capability;
    }

    String translate(String s) {
        if (s == null) {
            return null;
        }
        if (!s.startsWith("%")) {
            return s;
        }
        if (this.localization == null) {
            try {
                this.localization = new Properties();
                String path = this.manifest.getValue("Bundle-Localization", "bundle");
                path = path + ".properties";
                InputStream in = this.jar.getInputStream(new ZipEntry(path));
                if (in != null) {
                    this.localization.load(in);
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        s = s.substring(1);
        return this.localization.getProperty(s, s);
    }

    File getZipFile() {
        return this.bundleJar;
    }
}

