/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public final class NewThreadAction
implements PrivilegedAction {
    static final String NAME_PREFIX = "(JSK) ";
    static final ThreadGroup systemThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            ThreadGroup parent;
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            while ((parent = group.getParent()) != null) {
                group = parent;
            }
            return group;
        }
    });
    static final ThreadGroup userThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ThreadGroup(systemThreadGroup, "(JSK) Runtime");
        }
    });
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    private final ThreadGroup group;
    private final Runnable runnable;
    private final String name;
    private final boolean daemon;

    NewThreadAction(ThreadGroup group, Runnable runnable, String name, boolean daemon) {
        this.group = group;
        this.runnable = runnable;
        this.name = name;
        this.daemon = daemon;
    }

    public NewThreadAction(Runnable runnable, String name, boolean daemon) {
        this(systemThreadGroup, runnable, name, daemon);
    }

    public NewThreadAction(Runnable runnable, String name, boolean daemon, boolean user) {
        this(user ? userThreadGroup : systemThreadGroup, runnable, name, daemon);
    }

    public Object run() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getClassLoaderPermission);
        }
        Thread t = new Thread(this.group, this.runnable, NAME_PREFIX + this.name);
        t.setContextClassLoader(ClassLoader.getSystemClassLoader());
        t.setDaemon(this.daemon);
        return t;
    }
}

