/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WeakIdentityMap {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object put(Object key, Object value) {
        this.processQueue();
        return this.map.put(Key.create(key, this.queue), value);
    }

    public Object get(Object key) {
        this.processQueue();
        return this.map.get(Key.create(key, null));
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.map.remove(Key.create(key, null));
    }

    public Collection values() {
        this.processQueue();
        return this.map.values();
    }

    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    private void processQueue() {
        Key k;
        while ((k = (Key)this.queue.poll()) != null) {
            this.map.remove(k);
        }
    }

    private static class Key
    extends WeakReference {
        private final int hash;

        static Key create(Object k, ReferenceQueue q) {
            if (k == null) {
                return null;
            }
            if (q == null) {
                return new Key(k);
            }
            return new Key(k, q);
        }

        private Key(Object k) {
            super(k);
            this.hash = System.identityHashCode(k);
        }

        private Key(Object k, ReferenceQueue q) {
            super(k, q);
            this.hash = System.identityHashCode(k);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object k1 = this.get();
            Object k2 = ((Key)o).get();
            return k1 != null && k2 != null && k1 == k2;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

