// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package opensearchserverlessiface provides an interface to enable mocking the OpenSearch Service Serverless service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package opensearchserverlessiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/opensearchserverless"
)

// OpenSearchServerlessAPI provides an interface to enable mocking the
// opensearchserverless.OpenSearchServerless service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// OpenSearch Service Serverless.
//	func myFunc(svc opensearchserverlessiface.OpenSearchServerlessAPI) bool {
//	    // Make svc.BatchGetCollection request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := opensearchserverless.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockOpenSearchServerlessClient struct {
//	    opensearchserverlessiface.OpenSearchServerlessAPI
//	}
//	func (m *mockOpenSearchServerlessClient) BatchGetCollection(input *opensearchserverless.BatchGetCollectionInput) (*opensearchserverless.BatchGetCollectionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockOpenSearchServerlessClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OpenSearchServerlessAPI interface {
	BatchGetCollection(*opensearchserverless.BatchGetCollectionInput) (*opensearchserverless.BatchGetCollectionOutput, error)
	BatchGetCollectionWithContext(aws.Context, *opensearchserverless.BatchGetCollectionInput, ...request.Option) (*opensearchserverless.BatchGetCollectionOutput, error)
	BatchGetCollectionRequest(*opensearchserverless.BatchGetCollectionInput) (*request.Request, *opensearchserverless.BatchGetCollectionOutput)

	BatchGetVpcEndpoint(*opensearchserverless.BatchGetVpcEndpointInput) (*opensearchserverless.BatchGetVpcEndpointOutput, error)
	BatchGetVpcEndpointWithContext(aws.Context, *opensearchserverless.BatchGetVpcEndpointInput, ...request.Option) (*opensearchserverless.BatchGetVpcEndpointOutput, error)
	BatchGetVpcEndpointRequest(*opensearchserverless.BatchGetVpcEndpointInput) (*request.Request, *opensearchserverless.BatchGetVpcEndpointOutput)

	CreateAccessPolicy(*opensearchserverless.CreateAccessPolicyInput) (*opensearchserverless.CreateAccessPolicyOutput, error)
	CreateAccessPolicyWithContext(aws.Context, *opensearchserverless.CreateAccessPolicyInput, ...request.Option) (*opensearchserverless.CreateAccessPolicyOutput, error)
	CreateAccessPolicyRequest(*opensearchserverless.CreateAccessPolicyInput) (*request.Request, *opensearchserverless.CreateAccessPolicyOutput)

	CreateCollection(*opensearchserverless.CreateCollectionInput) (*opensearchserverless.CreateCollectionOutput, error)
	CreateCollectionWithContext(aws.Context, *opensearchserverless.CreateCollectionInput, ...request.Option) (*opensearchserverless.CreateCollectionOutput, error)
	CreateCollectionRequest(*opensearchserverless.CreateCollectionInput) (*request.Request, *opensearchserverless.CreateCollectionOutput)

	CreateSecurityConfig(*opensearchserverless.CreateSecurityConfigInput) (*opensearchserverless.CreateSecurityConfigOutput, error)
	CreateSecurityConfigWithContext(aws.Context, *opensearchserverless.CreateSecurityConfigInput, ...request.Option) (*opensearchserverless.CreateSecurityConfigOutput, error)
	CreateSecurityConfigRequest(*opensearchserverless.CreateSecurityConfigInput) (*request.Request, *opensearchserverless.CreateSecurityConfigOutput)

	CreateSecurityPolicy(*opensearchserverless.CreateSecurityPolicyInput) (*opensearchserverless.CreateSecurityPolicyOutput, error)
	CreateSecurityPolicyWithContext(aws.Context, *opensearchserverless.CreateSecurityPolicyInput, ...request.Option) (*opensearchserverless.CreateSecurityPolicyOutput, error)
	CreateSecurityPolicyRequest(*opensearchserverless.CreateSecurityPolicyInput) (*request.Request, *opensearchserverless.CreateSecurityPolicyOutput)

	CreateVpcEndpoint(*opensearchserverless.CreateVpcEndpointInput) (*opensearchserverless.CreateVpcEndpointOutput, error)
	CreateVpcEndpointWithContext(aws.Context, *opensearchserverless.CreateVpcEndpointInput, ...request.Option) (*opensearchserverless.CreateVpcEndpointOutput, error)
	CreateVpcEndpointRequest(*opensearchserverless.CreateVpcEndpointInput) (*request.Request, *opensearchserverless.CreateVpcEndpointOutput)

	DeleteAccessPolicy(*opensearchserverless.DeleteAccessPolicyInput) (*opensearchserverless.DeleteAccessPolicyOutput, error)
	DeleteAccessPolicyWithContext(aws.Context, *opensearchserverless.DeleteAccessPolicyInput, ...request.Option) (*opensearchserverless.DeleteAccessPolicyOutput, error)
	DeleteAccessPolicyRequest(*opensearchserverless.DeleteAccessPolicyInput) (*request.Request, *opensearchserverless.DeleteAccessPolicyOutput)

	DeleteCollection(*opensearchserverless.DeleteCollectionInput) (*opensearchserverless.DeleteCollectionOutput, error)
	DeleteCollectionWithContext(aws.Context, *opensearchserverless.DeleteCollectionInput, ...request.Option) (*opensearchserverless.DeleteCollectionOutput, error)
	DeleteCollectionRequest(*opensearchserverless.DeleteCollectionInput) (*request.Request, *opensearchserverless.DeleteCollectionOutput)

	DeleteSecurityConfig(*opensearchserverless.DeleteSecurityConfigInput) (*opensearchserverless.DeleteSecurityConfigOutput, error)
	DeleteSecurityConfigWithContext(aws.Context, *opensearchserverless.DeleteSecurityConfigInput, ...request.Option) (*opensearchserverless.DeleteSecurityConfigOutput, error)
	DeleteSecurityConfigRequest(*opensearchserverless.DeleteSecurityConfigInput) (*request.Request, *opensearchserverless.DeleteSecurityConfigOutput)

	DeleteSecurityPolicy(*opensearchserverless.DeleteSecurityPolicyInput) (*opensearchserverless.DeleteSecurityPolicyOutput, error)
	DeleteSecurityPolicyWithContext(aws.Context, *opensearchserverless.DeleteSecurityPolicyInput, ...request.Option) (*opensearchserverless.DeleteSecurityPolicyOutput, error)
	DeleteSecurityPolicyRequest(*opensearchserverless.DeleteSecurityPolicyInput) (*request.Request, *opensearchserverless.DeleteSecurityPolicyOutput)

	DeleteVpcEndpoint(*opensearchserverless.DeleteVpcEndpointInput) (*opensearchserverless.DeleteVpcEndpointOutput, error)
	DeleteVpcEndpointWithContext(aws.Context, *opensearchserverless.DeleteVpcEndpointInput, ...request.Option) (*opensearchserverless.DeleteVpcEndpointOutput, error)
	DeleteVpcEndpointRequest(*opensearchserverless.DeleteVpcEndpointInput) (*request.Request, *opensearchserverless.DeleteVpcEndpointOutput)

	GetAccessPolicy(*opensearchserverless.GetAccessPolicyInput) (*opensearchserverless.GetAccessPolicyOutput, error)
	GetAccessPolicyWithContext(aws.Context, *opensearchserverless.GetAccessPolicyInput, ...request.Option) (*opensearchserverless.GetAccessPolicyOutput, error)
	GetAccessPolicyRequest(*opensearchserverless.GetAccessPolicyInput) (*request.Request, *opensearchserverless.GetAccessPolicyOutput)

	GetAccountSettings(*opensearchserverless.GetAccountSettingsInput) (*opensearchserverless.GetAccountSettingsOutput, error)
	GetAccountSettingsWithContext(aws.Context, *opensearchserverless.GetAccountSettingsInput, ...request.Option) (*opensearchserverless.GetAccountSettingsOutput, error)
	GetAccountSettingsRequest(*opensearchserverless.GetAccountSettingsInput) (*request.Request, *opensearchserverless.GetAccountSettingsOutput)

	GetPoliciesStats(*opensearchserverless.GetPoliciesStatsInput) (*opensearchserverless.GetPoliciesStatsOutput, error)
	GetPoliciesStatsWithContext(aws.Context, *opensearchserverless.GetPoliciesStatsInput, ...request.Option) (*opensearchserverless.GetPoliciesStatsOutput, error)
	GetPoliciesStatsRequest(*opensearchserverless.GetPoliciesStatsInput) (*request.Request, *opensearchserverless.GetPoliciesStatsOutput)

	GetSecurityConfig(*opensearchserverless.GetSecurityConfigInput) (*opensearchserverless.GetSecurityConfigOutput, error)
	GetSecurityConfigWithContext(aws.Context, *opensearchserverless.GetSecurityConfigInput, ...request.Option) (*opensearchserverless.GetSecurityConfigOutput, error)
	GetSecurityConfigRequest(*opensearchserverless.GetSecurityConfigInput) (*request.Request, *opensearchserverless.GetSecurityConfigOutput)

	GetSecurityPolicy(*opensearchserverless.GetSecurityPolicyInput) (*opensearchserverless.GetSecurityPolicyOutput, error)
	GetSecurityPolicyWithContext(aws.Context, *opensearchserverless.GetSecurityPolicyInput, ...request.Option) (*opensearchserverless.GetSecurityPolicyOutput, error)
	GetSecurityPolicyRequest(*opensearchserverless.GetSecurityPolicyInput) (*request.Request, *opensearchserverless.GetSecurityPolicyOutput)

	ListAccessPolicies(*opensearchserverless.ListAccessPoliciesInput) (*opensearchserverless.ListAccessPoliciesOutput, error)
	ListAccessPoliciesWithContext(aws.Context, *opensearchserverless.ListAccessPoliciesInput, ...request.Option) (*opensearchserverless.ListAccessPoliciesOutput, error)
	ListAccessPoliciesRequest(*opensearchserverless.ListAccessPoliciesInput) (*request.Request, *opensearchserverless.ListAccessPoliciesOutput)

	ListAccessPoliciesPages(*opensearchserverless.ListAccessPoliciesInput, func(*opensearchserverless.ListAccessPoliciesOutput, bool) bool) error
	ListAccessPoliciesPagesWithContext(aws.Context, *opensearchserverless.ListAccessPoliciesInput, func(*opensearchserverless.ListAccessPoliciesOutput, bool) bool, ...request.Option) error

	ListCollections(*opensearchserverless.ListCollectionsInput) (*opensearchserverless.ListCollectionsOutput, error)
	ListCollectionsWithContext(aws.Context, *opensearchserverless.ListCollectionsInput, ...request.Option) (*opensearchserverless.ListCollectionsOutput, error)
	ListCollectionsRequest(*opensearchserverless.ListCollectionsInput) (*request.Request, *opensearchserverless.ListCollectionsOutput)

	ListCollectionsPages(*opensearchserverless.ListCollectionsInput, func(*opensearchserverless.ListCollectionsOutput, bool) bool) error
	ListCollectionsPagesWithContext(aws.Context, *opensearchserverless.ListCollectionsInput, func(*opensearchserverless.ListCollectionsOutput, bool) bool, ...request.Option) error

	ListSecurityConfigs(*opensearchserverless.ListSecurityConfigsInput) (*opensearchserverless.ListSecurityConfigsOutput, error)
	ListSecurityConfigsWithContext(aws.Context, *opensearchserverless.ListSecurityConfigsInput, ...request.Option) (*opensearchserverless.ListSecurityConfigsOutput, error)
	ListSecurityConfigsRequest(*opensearchserverless.ListSecurityConfigsInput) (*request.Request, *opensearchserverless.ListSecurityConfigsOutput)

	ListSecurityConfigsPages(*opensearchserverless.ListSecurityConfigsInput, func(*opensearchserverless.ListSecurityConfigsOutput, bool) bool) error
	ListSecurityConfigsPagesWithContext(aws.Context, *opensearchserverless.ListSecurityConfigsInput, func(*opensearchserverless.ListSecurityConfigsOutput, bool) bool, ...request.Option) error

	ListSecurityPolicies(*opensearchserverless.ListSecurityPoliciesInput) (*opensearchserverless.ListSecurityPoliciesOutput, error)
	ListSecurityPoliciesWithContext(aws.Context, *opensearchserverless.ListSecurityPoliciesInput, ...request.Option) (*opensearchserverless.ListSecurityPoliciesOutput, error)
	ListSecurityPoliciesRequest(*opensearchserverless.ListSecurityPoliciesInput) (*request.Request, *opensearchserverless.ListSecurityPoliciesOutput)

	ListSecurityPoliciesPages(*opensearchserverless.ListSecurityPoliciesInput, func(*opensearchserverless.ListSecurityPoliciesOutput, bool) bool) error
	ListSecurityPoliciesPagesWithContext(aws.Context, *opensearchserverless.ListSecurityPoliciesInput, func(*opensearchserverless.ListSecurityPoliciesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*opensearchserverless.ListTagsForResourceInput) (*opensearchserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *opensearchserverless.ListTagsForResourceInput, ...request.Option) (*opensearchserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*opensearchserverless.ListTagsForResourceInput) (*request.Request, *opensearchserverless.ListTagsForResourceOutput)

	ListVpcEndpoints(*opensearchserverless.ListVpcEndpointsInput) (*opensearchserverless.ListVpcEndpointsOutput, error)
	ListVpcEndpointsWithContext(aws.Context, *opensearchserverless.ListVpcEndpointsInput, ...request.Option) (*opensearchserverless.ListVpcEndpointsOutput, error)
	ListVpcEndpointsRequest(*opensearchserverless.ListVpcEndpointsInput) (*request.Request, *opensearchserverless.ListVpcEndpointsOutput)

	ListVpcEndpointsPages(*opensearchserverless.ListVpcEndpointsInput, func(*opensearchserverless.ListVpcEndpointsOutput, bool) bool) error
	ListVpcEndpointsPagesWithContext(aws.Context, *opensearchserverless.ListVpcEndpointsInput, func(*opensearchserverless.ListVpcEndpointsOutput, bool) bool, ...request.Option) error

	TagResource(*opensearchserverless.TagResourceInput) (*opensearchserverless.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *opensearchserverless.TagResourceInput, ...request.Option) (*opensearchserverless.TagResourceOutput, error)
	TagResourceRequest(*opensearchserverless.TagResourceInput) (*request.Request, *opensearchserverless.TagResourceOutput)

	UntagResource(*opensearchserverless.UntagResourceInput) (*opensearchserverless.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *opensearchserverless.UntagResourceInput, ...request.Option) (*opensearchserverless.UntagResourceOutput, error)
	UntagResourceRequest(*opensearchserverless.UntagResourceInput) (*request.Request, *opensearchserverless.UntagResourceOutput)

	UpdateAccessPolicy(*opensearchserverless.UpdateAccessPolicyInput) (*opensearchserverless.UpdateAccessPolicyOutput, error)
	UpdateAccessPolicyWithContext(aws.Context, *opensearchserverless.UpdateAccessPolicyInput, ...request.Option) (*opensearchserverless.UpdateAccessPolicyOutput, error)
	UpdateAccessPolicyRequest(*opensearchserverless.UpdateAccessPolicyInput) (*request.Request, *opensearchserverless.UpdateAccessPolicyOutput)

	UpdateAccountSettings(*opensearchserverless.UpdateAccountSettingsInput) (*opensearchserverless.UpdateAccountSettingsOutput, error)
	UpdateAccountSettingsWithContext(aws.Context, *opensearchserverless.UpdateAccountSettingsInput, ...request.Option) (*opensearchserverless.UpdateAccountSettingsOutput, error)
	UpdateAccountSettingsRequest(*opensearchserverless.UpdateAccountSettingsInput) (*request.Request, *opensearchserverless.UpdateAccountSettingsOutput)

	UpdateCollection(*opensearchserverless.UpdateCollectionInput) (*opensearchserverless.UpdateCollectionOutput, error)
	UpdateCollectionWithContext(aws.Context, *opensearchserverless.UpdateCollectionInput, ...request.Option) (*opensearchserverless.UpdateCollectionOutput, error)
	UpdateCollectionRequest(*opensearchserverless.UpdateCollectionInput) (*request.Request, *opensearchserverless.UpdateCollectionOutput)

	UpdateSecurityConfig(*opensearchserverless.UpdateSecurityConfigInput) (*opensearchserverless.UpdateSecurityConfigOutput, error)
	UpdateSecurityConfigWithContext(aws.Context, *opensearchserverless.UpdateSecurityConfigInput, ...request.Option) (*opensearchserverless.UpdateSecurityConfigOutput, error)
	UpdateSecurityConfigRequest(*opensearchserverless.UpdateSecurityConfigInput) (*request.Request, *opensearchserverless.UpdateSecurityConfigOutput)

	UpdateSecurityPolicy(*opensearchserverless.UpdateSecurityPolicyInput) (*opensearchserverless.UpdateSecurityPolicyOutput, error)
	UpdateSecurityPolicyWithContext(aws.Context, *opensearchserverless.UpdateSecurityPolicyInput, ...request.Option) (*opensearchserverless.UpdateSecurityPolicyOutput, error)
	UpdateSecurityPolicyRequest(*opensearchserverless.UpdateSecurityPolicyInput) (*request.Request, *opensearchserverless.UpdateSecurityPolicyOutput)

	UpdateVpcEndpoint(*opensearchserverless.UpdateVpcEndpointInput) (*opensearchserverless.UpdateVpcEndpointOutput, error)
	UpdateVpcEndpointWithContext(aws.Context, *opensearchserverless.UpdateVpcEndpointInput, ...request.Option) (*opensearchserverless.UpdateVpcEndpointOutput, error)
	UpdateVpcEndpointRequest(*opensearchserverless.UpdateVpcEndpointInput) (*request.Request, *opensearchserverless.UpdateVpcEndpointOutput)
}

var _ OpenSearchServerlessAPI = (*opensearchserverless.OpenSearchServerless)(nil)
