/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.plugins.frontend.split.ui;

import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.platform.plugins.frontend.split.PluginSetDiffKt;
import com.intellij.platform.plugins.frontend.split.PluginState;
import com.intellij.platform.plugins.frontend.split.PluginStateDiff;
import com.intellij.platform.plugins.frontend.split.PluginStateDiffType;
import com.intellij.platform.plugins.frontend.split.PluginSyncAdvice;
import com.intellij.platform.plugins.frontend.split.ui.ActionType;
import com.intellij.platform.plugins.frontend.split.ui.PluginAction;
import com.intellij.platform.plugins.frontend.split.ui.PluginItemWithActions;
import com.intellij.platform.plugins.frontend.split.ui.PluginPair;
import com.intellij.platform.plugins.shared.split.dto.PluginUpdateDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\tJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/plugins/frontend/split/ui/SyncPluginsViewModel;", "", "advice", "Lcom/intellij/platform/plugins/frontend/split/PluginSyncAdvice;", "<init>", "(Lcom/intellij/platform/plugins/frontend/split/PluginSyncAdvice;)V", "getAdvice$intellij_platform_plugins_frontend_split", "()Lcom/intellij/platform/plugins/frontend/split/PluginSyncAdvice;", "actionPluginPairs", "", "Lcom/intellij/platform/plugins/frontend/split/ui/PluginPair;", "getActionPluginPairs", "()Ljava/util/List;", "matchingPluginPairs", "getMatchingPluginPairs", "shouldSkipPlugin", "", "diff", "Lcom/intellij/platform/plugins/frontend/split/PluginStateDiff;", "buildClientItem", "Lcom/intellij/platform/plugins/frontend/split/ui/PluginItemWithActions;", "state", "Lcom/intellij/platform/plugins/frontend/split/PluginState;", "buildHostItem", "getSelectedClientActions", "Lcom/intellij/platform/plugins/frontend/split/ui/PluginAction;", "getSelectedHostActions", "intellij.platform.plugins.frontend.split"})
@SourceDebugExtension(value={"SMAP\nSyncPluginsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncPluginsDialog.kt\ncom/intellij/platform/plugins/frontend/split/ui/SyncPluginsViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,552:1\n1#2:553\n1#2:564\n1#2:586\n1617#3,9:554\n1869#3:563\n1870#3:565\n1626#3:566\n1374#3:567\n1460#3,2:568\n774#3:570\n865#3,2:571\n1462#3,3:573\n1617#3,9:576\n1869#3:585\n1870#3:587\n1626#3:588\n1374#3:589\n1460#3,2:590\n774#3:592\n865#3,2:593\n1462#3,3:595\n*S KotlinDebug\n*F\n+ 1 SyncPluginsDialog.kt\ncom/intellij/platform/plugins/frontend/split/ui/SyncPluginsViewModel\n*L\n511#1:564\n517#1:586\n511#1:554,9\n511#1:563\n511#1:565\n511#1:566\n512#1:567\n512#1:568,2\n512#1:570\n512#1:571,2\n512#1:573,3\n517#1:576,9\n517#1:585\n517#1:587\n517#1:588\n518#1:589\n518#1:590,2\n518#1:592\n518#1:593,2\n518#1:595,3\n*E\n"})
public final class SyncPluginsViewModel {
    @NotNull
    private final PluginSyncAdvice advice;
    @NotNull
    private final List<PluginPair> actionPluginPairs;
    @NotNull
    private final List<PluginPair> matchingPluginPairs;

    public SyncPluginsViewModel(@NotNull PluginSyncAdvice advice) {
        Intrinsics.checkNotNullParameter((Object)advice, (String)"advice");
        this.advice = advice;
        List allPairs = new ArrayList();
        List matchingPairs = new ArrayList();
        List actionNeededPairs = new ArrayList();
        for (PluginStateDiff diff : this.advice.getPluginDiff().getDiffs()) {
            boolean bl;
            PluginPair it;
            PluginPair pair;
            if (this.shouldSkipPlugin(diff)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[diff.getDiffType().ordinal()]) {
                case 1: {
                    PluginItemWithActions pluginItemWithActions;
                    PluginItemWithActions clientItem;
                    if (diff.getLeftState() != null) {
                        PluginState it2;
                        boolean bl2 = false;
                        v0 = this.buildClientItem(diff, it2);
                    } else {
                        v0 = clientItem = null;
                    }
                    if (diff.getRightState() != null) {
                        PluginState it3;
                        boolean bl3 = false;
                        pluginItemWithActions = this.buildHostItem(diff, it3);
                    } else {
                        pluginItemWithActions = null;
                    }
                    PluginItemWithActions hostItem = pluginItemWithActions;
                    PluginPair pluginPair = new PluginPair(clientItem, hostItem);
                    break;
                }
                case 2: {
                    PluginItemWithActions clientItem;
                    PluginPair pluginPair;
                    if (diff.getRightState() != null) {
                        PluginState hostState;
                        PluginUiModel clientUpdate;
                        boolean bl4 = false;
                        String clientPluginId = this.advice.getClientPluginIdByDiff().get(diff);
                        if (clientPluginId != null) {
                            String it4;
                            boolean bl5 = false;
                            v3 = this.advice.getClientUpdates().get(it4);
                        } else {
                            v3 = clientUpdate = null;
                        }
                        if (clientUpdate != null && hostState.isLoaded()) {
                            String string;
                            String string2 = clientUpdate.getName();
                            if (string2 == null) {
                                string2 = hostState.getHeader().getName();
                            }
                            if ((string = clientUpdate.getVendor()) == null) {
                                string = hostState.getHeader().getVendor();
                            }
                            clientItem = new PluginItemWithActions(null, clientPluginId, string2, string, null, clientUpdate.getVersion(), false, CollectionsKt.listOf((Object)new PluginAction(ActionType.INSTALL, true, true, clientPluginId, clientUpdate.getVersion())));
                            PluginItemWithActions hostItem = new PluginItemWithActions(hostState, hostState.getHeader().getPluginId(), hostState.getHeader().getName(), hostState.getHeader().getVendor(), hostState.getHeader().getVersion(), null, hostState.isLoaded(), CollectionsKt.emptyList());
                            pluginPair = new PluginPair(clientItem, hostItem);
                            break;
                        }
                        pluginPair = null;
                        break;
                    }
                    pluginPair = null;
                    break;
                }
                case 3: {
                    PluginItemWithActions clientItem;
                    PluginPair pluginPair;
                    if (diff.getLeftState() != null) {
                        PluginState clientState;
                        PluginUpdateDTO backendUpdate;
                        boolean bl6 = false;
                        String backendPluginId = this.advice.getBackendPluginIdByDiff().get(diff);
                        if (backendPluginId != null) {
                            String it5;
                            boolean bl7 = false;
                            v6 = this.advice.getBackendUpdates().get(it5);
                        } else {
                            v6 = backendUpdate = null;
                        }
                        if (backendUpdate != null && this.advice.isInstallOnBackendAllowed() && clientState.isLoaded()) {
                            String string;
                            clientItem = new PluginItemWithActions(clientState, clientState.getHeader().getPluginId(), clientState.getHeader().getName(), clientState.getHeader().getVendor(), clientState.getHeader().getVersion(), null, clientState.isLoaded(), CollectionsKt.emptyList());
                            String string3 = backendUpdate.getName();
                            if (string3 == null) {
                                string3 = clientState.getHeader().getName();
                            }
                            if ((string = backendUpdate.getVendor()) == null) {
                                string = clientState.getHeader().getVendor();
                            }
                            PluginItemWithActions hostItem = new PluginItemWithActions(null, backendPluginId, string3, string, null, backendUpdate.getVersion(), false, CollectionsKt.listOf((Object)new PluginAction(ActionType.INSTALL, true, true, backendPluginId, backendUpdate.getVersion())));
                            pluginPair = new PluginPair(clientItem, hostItem);
                            break;
                        }
                        pluginPair = null;
                        break;
                    }
                    pluginPair = null;
                    break;
                }
                default: {
                    PluginPair pluginPair = pair = null;
                }
            }
            if (pair == null) continue;
            boolean bl8 = false;
            if (diff.getDiffType() == PluginStateDiffType.MATCH) {
                bl = matchingPairs.add(it);
                continue;
            }
            bl = actionNeededPairs.add(it);
        }
        this.matchingPluginPairs = matchingPairs;
        this.actionPluginPairs = actionNeededPairs;
    }

    @NotNull
    public final PluginSyncAdvice getAdvice$intellij_platform_plugins_frontend_split() {
        return this.advice;
    }

    @NotNull
    public final List<PluginPair> getActionPluginPairs() {
        return this.actionPluginPairs;
    }

    @NotNull
    public final List<PluginPair> getMatchingPluginPairs() {
        return this.matchingPluginPairs;
    }

    private final boolean shouldSkipPlugin(PluginStateDiff diff) {
        if (((Boolean)PluginSetDiffKt.fold(diff, SyncPluginsViewModel::shouldSkipPlugin$lambda$7, SyncPluginsViewModel::shouldSkipPlugin$lambda$8)).booleanValue()) {
            return true;
        }
        String pluginId = (String)PluginSetDiffKt.fold(diff, SyncPluginsViewModel::shouldSkipPlugin$lambda$9, SyncPluginsViewModel::shouldSkipPlugin$lambda$10);
        return Intrinsics.areEqual((Object)pluginId, (Object)"com.intellij");
    }

    /*
     * WARNING - void declaration
     */
    private final PluginItemWithActions buildClientItem(PluginStateDiff diff, PluginState state) {
        String string;
        String clientPluginId;
        List actions = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[diff.getDiffType().ordinal()]) {
            case 4: {
                PluginUiModel clientUpdate;
                String string2 = clientPluginId = this.advice.getClientPluginIdByDiff().get(diff);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    v1 = this.advice.getClientUpdates().get(it);
                } else {
                    v1 = clientUpdate = null;
                }
                if (clientUpdate == null || Intrinsics.areEqual((Object)clientUpdate.getVersion(), (Object)state.getHeader().getVersion())) break;
                actions.add(new PluginAction(ActionType.UPDATE, true, true, clientPluginId, clientUpdate.getVersion()));
                break;
            }
            case 5: {
                if (state.isLoaded()) break;
                actions.add(new PluginAction(ActionType.ENABLE, true, true, state.getHeader().getPluginId(), null, 16, null));
            }
        }
        PluginState pluginState = state;
        String string3 = state.getHeader().getPluginId();
        String string4 = state.getHeader().getName();
        String string5 = state.getHeader().getVendor();
        String string6 = state.getHeader().getVersion();
        String string7 = this.advice.getClientPluginIdByDiff().get(diff);
        if (string7 != null) {
            void it;
            clientPluginId = string7;
            String string8 = string6;
            String string9 = string5;
            String string10 = string4;
            String string11 = string3;
            PluginState pluginState2 = pluginState;
            boolean bl = false;
            PluginUiModel pluginUiModel = this.advice.getClientUpdates().get(it);
            String string12 = pluginUiModel != null ? pluginUiModel.getVersion() : null;
            pluginState = pluginState2;
            string3 = string11;
            string4 = string10;
            string5 = string9;
            string6 = string8;
            string = string12;
        } else {
            string = null;
        }
        List list = actions;
        boolean bl = state.isLoaded();
        String string13 = string;
        String string14 = string6;
        String string15 = string5;
        String string16 = string4;
        String string17 = string3;
        PluginState pluginState3 = pluginState;
        return new PluginItemWithActions(pluginState3, string17, string16, string15, string14, string13, bl, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PluginItemWithActions buildHostItem(PluginStateDiff diff, PluginState state) {
        String string;
        String backendPluginId;
        List actions = new ArrayList();
        if (this.advice.isInstallOnBackendAllowed()) {
            switch (WhenMappings.$EnumSwitchMapping$0[diff.getDiffType().ordinal()]) {
                case 4: {
                    PluginUpdateDTO backendUpdate;
                    String string2 = backendPluginId = this.advice.getBackendPluginIdByDiff().get(diff);
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        v1 = this.advice.getBackendUpdates().get(it);
                    } else {
                        v1 = backendUpdate = null;
                    }
                    if (backendUpdate == null || Intrinsics.areEqual((Object)backendUpdate.getVersion(), (Object)state.getHeader().getVersion())) break;
                    actions.add(new PluginAction(ActionType.UPDATE, true, true, backendPluginId, backendUpdate.getVersion()));
                    break;
                }
                case 6: {
                    if (state.isLoaded()) break;
                    actions.add(new PluginAction(ActionType.ENABLE, true, false, state.getHeader().getPluginId(), null, 16, null));
                }
            }
        }
        PluginState pluginState = state;
        String string3 = state.getHeader().getPluginId();
        String string4 = state.getHeader().getName();
        String string5 = state.getHeader().getVendor();
        String string6 = state.getHeader().getVersion();
        String string7 = this.advice.getBackendPluginIdByDiff().get(diff);
        if (string7 != null) {
            void it;
            backendPluginId = string7;
            String string8 = string6;
            String string9 = string5;
            String string10 = string4;
            String string11 = string3;
            PluginState pluginState2 = pluginState;
            boolean bl = false;
            PluginUpdateDTO pluginUpdateDTO = this.advice.getBackendUpdates().get(it);
            String string12 = pluginUpdateDTO != null ? pluginUpdateDTO.getVersion() : null;
            pluginState = pluginState2;
            string3 = string11;
            string4 = string10;
            string5 = string9;
            string6 = string8;
            string = string12;
        } else {
            string = null;
        }
        List list = actions;
        boolean bl = state.isLoaded();
        String string13 = string;
        String string14 = string6;
        String string15 = string5;
        String string16 = string4;
        String string17 = string3;
        PluginState pluginState3 = pluginState;
        return new PluginItemWithActions(pluginState3, string17, string16, string15, string14, string13, bl, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginAction> getSelectedClientActions() {
        void $this$flatMapTo$iv$iv;
        Object it;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)this.actionPluginPairs, (Iterable)this.matchingPluginPairs);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginItemWithActions it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (PluginPair)element$iv$iv;
            boolean bl2 = false;
            if (((PluginPair)it).getClientItem() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            PluginItemWithActions it2 = (PluginItemWithActions)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it2.getActions();
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                PluginAction action = (PluginAction)element$iv$iv2;
                boolean bl4 = false;
                if (!action.getSelected()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginAction> getSelectedHostActions() {
        void $this$flatMapTo$iv$iv;
        Object it;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)this.actionPluginPairs, (Iterable)this.matchingPluginPairs);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginItemWithActions it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (PluginPair)element$iv$iv;
            boolean bl2 = false;
            if (((PluginPair)it).getHostItem() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            PluginItemWithActions it2 = (PluginItemWithActions)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it2.getActions();
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                PluginAction action = (PluginAction)element$iv$iv2;
                boolean bl4 = false;
                if (!action.getSelected()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean shouldSkipPlugin$lambda$7(PluginState $this$fold) {
        Intrinsics.checkNotNullParameter((Object)$this$fold, (String)"$this$fold");
        return $this$fold.getHeader().isImplementationDetail();
    }

    private static final boolean shouldSkipPlugin$lambda$8(boolean left, boolean right) {
        return left || right;
    }

    private static final String shouldSkipPlugin$lambda$9(PluginState $this$fold) {
        Intrinsics.checkNotNullParameter((Object)$this$fold, (String)"$this$fold");
        return $this$fold.getHeader().getPluginId();
    }

    private static final String shouldSkipPlugin$lambda$10(String left, String string) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return left;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PluginStateDiffType.values().length];
            try {
                nArray[PluginStateDiffType.MATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginStateDiffType.INSTALLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginStateDiffType.UNINSTALLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginStateDiffType.VERSION_MISMATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginStateDiffType.UNLOADED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginStateDiffType.LOADED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

