#ifdef __APPLE__
#import <Cocoa/Cocoa.h>
#ifdef __ppc__
#include <QuickTime/QuickTimeComponents.h>
#endif
#ifndef NSINTEGER_DEFINED //appears with 10.5 in NSObjCRuntime.h
#if defined(__LP64__) && __LP64__
typedef long NSInteger;
typedef unsigned long NSUInteger;
#else
typedef int NSInteger;
typedef unsigned int NSUInteger;
#endif
#endif
#include "seaview.h"
#include <FL/x.H>
#include <FL/Fl_Sys_Menu_Bar.H>
#include <FL/Fl_Help_View.H>
#include <FL/filename.H>
#include "FL/fl_draw.H"
#include <sys/stat.h>
#include <unistd.h>

// included functions
char *mac_fname_to_roman(const char *in);
void fl_ringbell(int a);
extern "C" {
	const char *MG_GetBundleResourcesDir(void);
	void PtoC(const void *in, void *out);
	void CtoP(const void *in, void *out);
	void show_apropos(Fl_Widget *, void *unused);
	void MG_apple_inits(void);
}
void set_seaview_modified(SEA_VIEW *view, int ismodified);
void windowmenuitem_callback(Fl_Widget *o, void *data);
int find_windowmenuitem(Fl_Window *w);
int add_windowmenuitem(const char *name, Fl_Window *w);
void rename_windowmenuitem(const char *name, int rank);
void delete_windowmenuitem(int rank);
char *mac_GetOutputFName_Plus(const char *dfault, const char *message, int, const char *directory);
void MG_fl_draw(const char *txt, int x, int y);
void MG_fl_line(int x, int y, int x1, int y1);
void MG_fl_rect(int x, int y, int w, int h);
void MG_fl_rectf(int x, int y, int w, int h);
void MG_fl_font(int fontrank, int size);
void MG_fl_color(Fl_Color color);
float MG_fl_width(char *txt, int l);
void *MG_PrepareCopy(int w, int h);
void MG_CompleteCopy(void *mypicture);
static size_t MyPutBytes (void* info, const void* buffer, size_t count);
#if !__LP64__
QDPictRef MyPictToQDPict(PicHandle mypicture);
void MyCopyPictToClipboard (PicHandle mypicture);
#endif
void *prepare_copy_pdf_and_pict(int w, int h);
void complete_copy_pdf_and_pict(void *data);
void draw_rotated_string(const char *txt, int x, int y, float degrees /*clockwise*/);

/* extern functions */
extern void hide_window_callback(Fl_Widget *ob, void *data);
extern char *get_res_value(const char *name, const char *def_value);
extern int printout_block, printout_fontsize;
extern int printout_vary, printout_black;
extern paperformat printout_pageformat;

/* globals */
#if !__LP64__
static int MG_doing_copy = 0;
#endif

void fl_ringbell(int a)
{
  fl_beep(FL_BEEP_DEFAULT);
}


char *mac_fname_to_roman(const char *in)
/* passage codage pathname vers codage MacRoman qui semble necessaire pour display ecran 
 */
{
  static char out[250];
  CFStringRef mycfs;
  Boolean ok;
  /* j'ai cru comprendre que les pathnames sont codes en UTF8 */
  mycfs = CFStringCreateWithCString(NULL, in, kCFStringEncodingUTF8);
  /* et que MacRoman est utilise pour display */
  ok = CFStringGetCString(mycfs, out, sizeof(out), kCFStringEncodingMacRoman);
  CFRelease(mycfs);
  return (ok ? out : (char *)in);
}

/*
pid_t get_desc_process(pid_t ascend)
//returns the pid of the first descending process from process of pid ascend
//or 0 if no descendant
{
	FILE *pipe;
	char command[] = "/bin/ps -U $USER -o pid,ppid ";
	char line[2000], *p;
	long long pid, ppid;
	
	pipe = popen(command, "r");
	fgets(line, sizeof(line), pipe); // skip first line
	while(TRUE)	{
		p = fgets(line, sizeof(line), pipe);
		pid = 0;
		if(p == NULL) break;
		sscanf(line, "%lld%lld", &pid, &ppid);
		if( (pid_t)ppid == ascend) break;
	}
	pclose(pipe);
	return (pid_t) pid;
}


void kill_last_desc(pid_t ascend)
//kills the deepest descendant process from process ascend, if any
{
	pid_t son, father;
	
	father = ascend;
	do {
		son = get_desc_process(father);
		if(son != 0) father = son;
	}
	while(son != 0);
	if(father != ascend) kill(father, SIGKILL);
}
*/

const char *MG_GetBundleResourcesDir(void)
{
  return [[[NSBundle mainBundle] resourcePath] UTF8String];
}


static void label(int x, int y, int w, int h, const char *text, NSView *view)
{
  NSRect rect = {x, y, w, h};
  NSTextField *label = [[[NSTextField alloc] initWithFrame:rect] autorelease];
  [label setStringValue:[[[NSString alloc] initWithUTF8String:text] autorelease]];
  [label setEditable:NO];
  [label setSelectable:NO];
  [label setBordered:NO];
  [label setDrawsBackground:NO];
  [view addSubview:label];
}

char *mac_GetOutputFName_Plus(const char *dfault, const char *message, int use_only_button, const char *directory)
{
  static char pathname[FL_PATH_MAX];
  NSAutoreleasePool *localPool;
  localPool = [[NSAutoreleasePool alloc] init]; 
  NSSavePanel *_panel =  [NSSavePanel savePanel];
  CFStringRef cfs_title;
  cfs_title = CFStringCreateWithCString(NULL,message,kCFStringEncodingUTF8);
  [_panel setTitle:(NSString*)cfs_title];
  CFRelease(cfs_title);
  [_panel setNameFieldLabel:@"Output To:"];
  NSString *dir = [[NSString alloc] initWithUTF8String:directory];
  NSString *preset = [[NSString alloc] initWithUTF8String:dfault];
  NSString *fname = [preset lastPathComponent];
  NSRect rectview = {0, 0, 500, 65 };
  NSView *view = [[[NSView alloc] initWithFrame:rectview] autorelease];
//blocksize  
  label(12, 15, 45, 30, "block\nsize:", view);
  NSRect rectblock = {50, 20, 35, 20 };
  NSTextField *blockview = [[[NSTextField alloc] initWithFrame:rectblock] autorelease];
  [view addSubview:blockview];
  [blockview setIntValue:printout_block];
//fontsize
  label(102, 15, 45, 30, "font\nsize:", view);
  NSRect rectfont = {140, 20, 35, 20 };
  NSTextField *fontview = [[[NSTextField alloc] initWithFrame:rectfont] autorelease];
  [view addSubview:fontview];
  [fontview setIntValue:printout_fontsize];
//color  
  NSRect pdfrect = {190, -10, 80, 70 };
  NSMatrix *pdfmatrix = [[[NSMatrix alloc] initWithFrame:pdfrect mode:NSRadioModeMatrix 
						cellClass:[NSButtonCell class]
					 numberOfRows:3 numberOfColumns:1] autorelease];
  [pdfmatrix setAllowsEmptySelection:NO];
  NSButton *color = [[[NSButton alloc] init] autorelease];
  [color setButtonType:NSRadioButton];
  [color setTitle:@"PDF color"];
  [color sizeToFit];
  [pdfmatrix putCell:[color cell] atRow:0 column:0];
  NSButton *bw = [[[NSButton alloc] init] autorelease];
  [bw setButtonType:NSRadioButton];
  [bw setTitle:@"PDF B&W"];
  [bw sizeToFit];
  [pdfmatrix putCell:[bw cell] atRow:1 column:0];
  NSButton *textfile = [[[NSButton alloc] init] autorelease];
  [textfile setButtonType:NSRadioButton];
  [textfile setTitle:@"Text File"];
  [textfile sizeToFit];
  [pdfmatrix putCell:[textfile cell] atRow:2 column:0];
  [pdfmatrix selectCell:[bw cell]];
  if([pdfmatrix selectedRow] != printout_black) [pdfmatrix selectCellAtRow:printout_black column:0];
  [view addSubview:pdfmatrix];
//paper format  
  NSRect paperrect = {280, -10, 80, 60 };
  NSMatrix *papermatrix = [[[NSMatrix alloc] initWithFrame:paperrect mode:NSRadioModeMatrix 
						 cellClass:[NSButtonCell class]
					      numberOfRows:2 numberOfColumns:1] autorelease];
  [papermatrix setAllowsEmptySelection:NO];
  NSButton *A4 = [[[NSButton alloc] init] autorelease];
  [A4 setButtonType:NSRadioButton];
  [A4 setTitle:@"A4"];
  [A4 sizeToFit];
  [papermatrix putCell:[A4 cell] atRow:0 column:0];
  NSButton *LETTER = [[[NSButton alloc] init] autorelease];
  [LETTER setButtonType:NSRadioButton];
  [LETTER setTitle:@"LETTER"];
  [LETTER sizeToFit];
  [papermatrix putCell:[LETTER cell] atRow:1 column:0];
  [papermatrix selectCell:[LETTER cell]];
  if([papermatrix selectedRow] != printout_pageformat) [papermatrix selectCellAtRow:printout_pageformat column:0];
  [view addSubview:papermatrix];
//variable site button  
  NSRect variablerect = {360, 20, 80, 20 };
  NSButton *variable = [[[NSButton alloc] initWithFrame:variablerect] autorelease];
  [variable setButtonType:NSSwitchButton];
  [variable setTitle:@"variable sites only"];
  [variable sizeToFit];
  [variable setIntValue:printout_vary];
  [variable setEnabled:use_only_button];
  [view addSubview:variable];
//add accessory view to panel
  [_panel setAccessoryView:view];
//run panel  
  NSInteger retval = [(NSSavePanel*)_panel runModalForDirectory:dir file:fname];
  [preset release];
  [dir release];
  if ( retval == NSOKButton ) {//read accessory view state
    printout_block = [blockview intValue];
    printout_fontsize = [fontview intValue];
    printout_black = [pdfmatrix selectedRow];
    printout_pageformat = (paperformat)[papermatrix selectedRow];
    printout_vary = [variable intValue];
    strcpy(pathname, [[_panel filename] fileSystemRepresentation]);
    }
  [localPool release];
  if ( retval == NSCancelButton ) return NULL;
  return pathname;
}


void windowmenuitem_callback(Fl_Widget *o, void *data)
{
  ((Fl_Window *)data)->show();
  const char *c = ((Fl_Window *)data)->xclass();
  if(c == NULL) return;
  if(strcmp(c, SEAVIEW_WINDOW) == 0) {
    SEA_VIEW *view = (SEA_VIEW *)((Fl_Window *)data)->user_data();
    view->DNA_obj->take_focus();
    }
}


int find_windowmenuitem(Fl_Window *w)
{
  const Fl_Menu_Item *items = fl_sys_menu_bar->Fl_Menu_::menu();
  int count = fl_sys_menu_bar->Fl_Menu_::size();
  for(int i = 1; i < count; i++) {
    if(items[i].user_data() == w) return i;
  }
  return -1;
}

int add_windowmenuitem(const char *name, Fl_Window *w)
//returns rank of new menu item or -1 if error
{
  if(fl_sys_menu_bar == NULL) new Fl_Sys_Menu_Bar(0,0,0,0,NULL);
  char line[200];
  sprintf(line, "Window/%s", name ? name : "<empty>");
  int val = fl_sys_menu_bar->add(line, 0, windowmenuitem_callback, w);
  return val;
}


void rename_windowmenuitem(const char *name, int rank)
{
  fl_sys_menu_bar->replace(rank, name);
}

void delete_windowmenuitem(int rank)
{
  fl_sys_menu_bar->remove(rank);
}


void show_apropos(Fl_Widget *w, void *unused)
{
  static Fl_Window *about = NULL;
  char line[100], *p;
  FILE *data;
  static char text[5000];
  
  if(about == NULL) {
	  about = new Fl_Window(600, 450, "About seaview");
	  Fl_Help_View *br = new Fl_Help_View(1, 1, about->w() - 2, about->h() - 2);
	  Fl_Button *b = new Fl_Button(1, 1, 1, 1, NULL);//only to allow the shortcut
	  b->callback(hide_window_callback, NULL);
	  b->shortcut(myFL_CTRL | 'w');
	  about->end();
	  p = get_full_path(get_res_value("helpfile", "seaview.html"));
	  if(p == NULL) return;
	  data = fopen(p, "r");
	  if(data == NULL) return;
	  p = text;
	  int doit = 0;
	  while(TRUE) {
		  fgets(line, sizeof(line), data);
		  if(strncmp(line, "<a name=", 8) == 0) doit = 1;
		  if(strncmp(line, "<hr>", 4) == 0) break;
		  if(doit) {
			  strcpy(p, line);
			  p += strlen(p);
			  }
	  }
	  fclose(data);
	  br->value(text);
	  about->resizable(br);
  }
  about->show();
}


void MG_apple_inits(void)
{
  Fl::set_font(FL_COURIER,"Courier");
  Fl::set_font(FL_COURIER_BOLD,"Courier Bold");
  if (fl_mac_os_version >= 100500) { // it seems that Courier Oblique is not present on older OS
    Fl::set_font(FL_COURIER_ITALIC,"Courier Oblique");
    Fl::set_font(FL_COURIER_BOLD_ITALIC,"Courier Bold Oblique");
    }
}


void set_seaview_modified(SEA_VIEW *view, int ismodified)
{
  view->modif_but_not_saved = ismodified;
  [(NSWindow*)(fl_xid(view->dnawin)) setDocumentEdited:ismodified];
}

#if !__LP64__
void CtoP(const void *in, void *out)
{
  char *vout = (char *)out;
  int l;
  if(in == NULL) l = 0;
  else	{
	l = strlen( (char *)in );
	memcpy(vout + 1, in, l);
  }
  vout[0] = l;
}


void MG_fl_draw(const char *txt, int x, int y)
{
  if(txt == NULL) return;
  if(!MG_doing_copy){
	  fl_draw(txt, x, y);
	  return;
  }
  unsigned char copy[strlen(txt) + 1];
  CtoP(txt, copy);
  MoveTo(x, y);
  DrawString(copy);
}

void MG_fl_line(int x, int y, int x1, int y1)
{
  if(!MG_doing_copy){
	  fl_line(x, y, x1, y1);
	  return;
  }
  MoveTo(x, y);
  LineTo(x1, y1);
}

void MG_fl_rect(int x, int y, int w, int h)
{
  if(!MG_doing_copy){
	  fl_rect(x, y, w, h);
	  return;
  }
  MoveTo(x, y);
  LineTo(x, y+h-1);
  LineTo(x+w-1, y+h-1);
  LineTo(x+w-1, y);
  LineTo(x, y);
}

void MG_fl_rectf(int x, int y, int w, int h)
{
  if(!MG_doing_copy){
	  fl_rectf(x, y, w, h);
	  return;
  }
  Rect r;
  r.top = (short)y;
  r.left = (short)x;
  r.bottom = (short)(y+h);
  r.right = (short)(x+w);
  PaintRect(&r);
}

void MG_fl_font(int fontrank, int size)
{
  if(!MG_doing_copy){
	  fl_font(fontrank, size);
	  return;
  }
  Style mystyle = normal;
  int macfont, fontstyle;
  if(fontrank < FL_SYMBOL) {
	  fontstyle = fontrank % 4;
	  fontrank -= fontstyle;
  }
  if(fontrank == FL_COURIER)
	  macfont=kFontIDCourier/*22*/;
  else if(fontrank == FL_HELVETICA)
	  macfont=kFontIDHelvetica/*21*/;
  else if(fontrank == FL_TIMES)
	  macfont=kFontIDTimes/*20*/;
  else if(fontrank == FL_SYMBOL)
	  macfont=kFontIDSymbol/*23*/;
  else
	  macfont=21; 
  if(fontrank < FL_SYMBOL) {
	  if(fontstyle == 0) mystyle = normal;
	  else if(fontstyle == 1) mystyle = bold;
	  else if(fontstyle == 2) mystyle = italic;
	  else if(fontstyle == 3) mystyle = bold+italic;
  }
  TextFont(macfont);
  TextSize(size);
  TextFace(mystyle);
}

void MG_fl_color(Fl_Color color)
{
  if(!MG_doing_copy){
	  fl_color(color);
	  return;
  }
  unsigned char r, g, b;
  Fl::get_color(color, r, g, b);
  RGBColor maccolor;
  maccolor.red = r << 8;
  maccolor.green = g << 8;
  maccolor.blue = b << 8;
  RGBForeColor(&maccolor);
}

float MG_fl_width(char *txt, int l)
{
  if(!MG_doing_copy){
	  return fl_width(txt, l);
  }
  return (float)TextWidth( txt, 0, l );
}

float MG_fl_width(char *txt)
{
	return MG_fl_width(txt, strlen(txt));
}
#endif


void *MG_PrepareCopy(int w, int h)
{
#if __LP64__
  return prepare_copy_pdf_and_pict(w, h);
#else
  Rect myrect;
  myrect.top=0;
  myrect.left=0;
  myrect.right=w;
  myrect.bottom=h;
  PicHandle mypicture = OpenPicture(&myrect);
  ClipRect(&myrect);
  PenNormal();
  MG_doing_copy = 1;
  return mypicture;
#endif
}


void MG_CompleteCopy(void *mypicture)
{
#if __LP64__
  complete_copy_pdf_and_pict(mypicture);
#else
  ClosePicture();
  MG_doing_copy = 0;
  MyCopyPictToClipboard((PicHandle)mypicture);
  KillPicture((PicHandle)mypicture);
#endif
}


static size_t MyPutBytes (void* info, const void* buffer, size_t count)
{
  CFDataAppendBytes ((CFMutableDataRef) info, (const UInt8 *)buffer, count);
  return count;
}


#if !__LP64__
QDPictRef MyPictToQDPict(PicHandle mypicture)
{
  CFIndex pictlen;
  CGDataProviderRef provider;
  /* conversion picture to QDPict */
  pictlen = GetHandleSize( (Handle)  mypicture);
  HLock( (Handle) mypicture);
  provider = CGDataProviderCreateWithData (NULL, *mypicture, pictlen, NULL);
  HUnlock( (Handle) mypicture);
  if (provider != NULL) {
	  QDPictRef myqdpict = QDPictCreateWithProvider (provider);
	  CFRelease(provider);
	  return myqdpict;
  }
  else return NULL;
  return NULL;
}


void MyCopyPictToClipboard (PicHandle mypicture)
{
  static CGDataConsumerCallbacks callbacks = { MyPutBytes, NULL };
  CFDataRef  data = NULL;
  PasteboardRef clipboard = NULL;
  CFIndex pictlen;
  QDPictRef myqdpict;	
  
  pictlen = GetHandleSize( (Handle)  mypicture);
  PasteboardCreate (kPasteboardClipboard, &clipboard);
  PasteboardClear(clipboard);
  HLock( (Handle) mypicture);
  data = CFDataCreate( kCFAllocatorDefault, (UInt8*)*mypicture, pictlen );
  HUnlock( (Handle) mypicture);
  PasteboardPutItemFlavor(clipboard, (PasteboardItemID)1, 
				      /* kUTTypePICT */ CFSTR("com.apple.pict"),
				      data,
				      kPasteboardFlavorNoFlags );
  CFRelease (data);    
  
  myqdpict = MyPictToQDPict(mypicture);
  data = CFDataCreateMutable (kCFAllocatorDefault, 0);
  if (data != NULL)
  {
      CGDataConsumerRef consumer = NULL;
      consumer = CGDataConsumerCreate ((void*) data, &callbacks);
      if (consumer != NULL) 
      {
	  CGContextRef context = NULL;
	  CGRect bounds = QDPictGetBounds (myqdpict);
	  bounds.origin.x = 0;
	  bounds.origin.y = 0;
	  context = CGPDFContextCreate (consumer, &bounds, NULL);
	  CGDataConsumerRelease (consumer);
	  if (context != NULL) 
	  {
	      /* convert PICT to PDF */
	      CGContextBeginPage (context, &bounds);
	      (void) QDPictDrawToCGContext (context, bounds, myqdpict);
	      CGContextEndPage (context);
	      CGContextRelease (context);
			      
	      /* copy PDF to clipboard */
	      (void) PasteboardPutItemFlavor (clipboard, (PasteboardItemID)1, 
					      /* kUTTypePDF */ CFSTR("com.adobe.pdf"), 
					      data, kPasteboardFlavorNoFlags);
	  }
      }
	      CFRelease (data); 
  }
  CFRelease (clipboard);
  if(myqdpict != NULL) QDPictRelease(myqdpict);
}
#endif

//next 2 functions copy quartz data to clipboard both as pdf and as PICT (or tiff for 64-bit) bitmap
void *prepare_copy_pdf_and_pict(int w, int h)
{
  if (fl_gc) CGContextRestoreGState(fl_gc);
  //prepare to draw in pdf context
  CGRect bounds = CGRectMake(0, 0, w, h );	
  CFMutableDataRef pdfdata = CFDataCreateMutable(NULL, 0);
  CGDataConsumerRef myconsumer;
  if(CGDataConsumerCreateWithCFData != NULL) { // true from 10.4
    myconsumer = CGDataConsumerCreateWithCFData (pdfdata);
    }
  else {
    static CGDataConsumerCallbacks callbacks = { MyPutBytes, NULL };
    myconsumer = CGDataConsumerCreate ((void*) pdfdata, &callbacks);
    }
  fl_gc = CGPDFContextCreate (myconsumer, &bounds, NULL);
  CGDataConsumerRelease (myconsumer);
  if (fl_gc == NULL) return NULL;
  CGContextBeginPage (fl_gc, NULL);
  CGContextTranslateCTM(fl_gc, 0, h);
  CGContextScaleCTM(fl_gc, 1.0f, -1.0f);
  return (void *)pdfdata;
}


void complete_copy_pdf_and_pict(void *data)
{
  int w, h;
  CFMutableDataRef pdfdata = (CFMutableDataRef)data;
  CGContextEndPage (fl_gc);
  CGContextRelease (fl_gc);
  PasteboardRef clipboard = NULL;
  PasteboardCreate (kPasteboardClipboard, &clipboard);
  PasteboardClear(clipboard); //	copy PDF to clipboard 
  PasteboardPutItemFlavor (clipboard, (PasteboardItemID)1, 
						   CFSTR("com.adobe.pdf"), // kUTTypePDF
						   pdfdata, kPasteboardFlavorNoFlags);
  
  
  //second, transform this PDF to a bitmap image and put it as PICT/jpeg in clipboard
  CGDataProviderRef prov;
  if(fl_mac_os_version >= 100400) { // true from 10.4
    prov = CGDataProviderCreateWithCFData(pdfdata);
    }
  else {
    prov = CGDataProviderCreateWithData(NULL, CFDataGetBytePtr(pdfdata), CFDataGetLength(pdfdata), NULL);
  }
  CGPDFDocumentRef pdfdoc = CGPDFDocumentCreateWithProvider(prov);
  CGPDFPageRef pdfpage = CGPDFDocumentGetPage(pdfdoc, 1);
  CGRect clip = CGPDFPageGetBoxRect(pdfpage, kCGPDFCropBox);
  w = (int)(clip.size.width + 0.5);
  h = (int)(clip.size.height + 0.5);
  CGDataProviderRelease(prov);
  CGColorSpaceRef space = CGColorSpaceCreateWithName(
				fl_mac_os_version >= 100400 ? kCGColorSpaceGenericRGB : kCGColorSpaceUserRGB	     
						     );
  const int scale = 2;
  w *= scale; h *= scale;
  void *mem = malloc(w * h * sizeof(int));
  fl_gc = CGBitmapContextCreate(mem, w, h, 8, w * 4, space, kCGImageAlphaPremultipliedFirst /*| kCGBitmapByteOrder32Host*/);
  CFRelease(space);
  if (fl_gc == NULL) { free(mem); return; }
  CGRect rect = CGRectMake(0, 0, w, h);
  CGContextSetRGBFillColor(fl_gc,  1,1,1,1);//need to clear background
  CGContextFillRect(fl_gc, rect);
  CGContextDrawPDFDocument(fl_gc, rect, pdfdoc, 1);
  CGPDFDocumentRelease(pdfdoc);
  CFRelease(pdfdata);
  if(fl_mac_os_version >= 100400) {// way for >= 10.4 that doesn't use QuickTime:
    CFMutableDataRef pictdata = CFDataCreateMutable(NULL, 0);
#if __LP64__
    CFStringRef  uti = CFSTR("public.tiff");
#else
    CFStringRef  uti = CFSTR("com.apple.pict");
#endif
    CGImageRef image = CGBitmapContextCreateImage(fl_gc);
    CGImageDestinationRef dest = CGImageDestinationCreateWithData(pictdata, uti, 1, NULL);
    CGImageDestinationAddImage(dest, image, NULL);
    CGImageDestinationFinalize(dest);
    CGImageRelease(image);
    CFRelease(dest);
#if !__LP64__
    CFRange range = CFRangeMake(0, 512);
    CFDataDeleteBytes(pictdata, range);// The PICT clipboard REQUIRES only the image data, not the header.
#endif
    PasteboardPutItemFlavor(clipboard, (PasteboardItemID)1, uti, pictdata, kPasteboardFlavorNoFlags );
    CFRelease (pictdata);    
    }
  else {// way for < 10.4 that uses QuickTime:
#ifdef __ppc__
    GraphicsExportComponent exporter;
    OSErr err = OpenADefaultComponent(GraphicsExporterComponentType, kQTFileTypePicture /*'PICT'*/, &exporter);
    err = GraphicsExportSetInputCGBitmapContext(exporter, fl_gc);
    Handle dataHandle = NewHandle(0);
    err = GraphicsExportSetOutputHandle(exporter, dataHandle);
    unsigned long size;
    err = GraphicsExportDoExport(exporter, &size);
    err = CloseComponent(exporter); 
    if(GetHandleSize(dataHandle) > 512) {
      HLock(dataHandle);
      // The clipboard REQUIRES only the image data, not the header.
      CFDataRef pictdata = CFDataCreate(NULL, (const UInt8 *)*dataHandle + 512, GetHandleSize(dataHandle) - 512);
      HUnlock(dataHandle);
      PasteboardPutItemFlavor(clipboard, (PasteboardItemID)1, 
						      CFSTR("com.apple.pict"),
						      pictdata,
						      kPasteboardFlavorNoFlags ); 
      CFRelease (pictdata);    
    }
    DisposeHandle(dataHandle);
#endif
  }
  CFRelease (clipboard);    
  CGContextRelease(fl_gc);
  fl_gc = NULL;
  free(mem);
}


void draw_rotated_string(const char *txt, int x, int y, float degrees /*clockwise*/)
{
  fl_draw(-(int)(degrees + 0.5), txt, strlen(txt), x, y);
}

#endif //__APPLE__
