#ifndef TREEDRAW_H
#define TREEDRAW_H
#include <seaview.h>
#include "FL/Fl_Round_Button.H"
#include "FL/Fl_Button.H"
#include "FL/Fl_Check_Button.H"
#include <FL/Fl_Scrollbar.H>
#include <FL/Fl_Counter.H>

#define myrint(x) (int)floor(x + 0.5)

struct noeud {
	double l1,l2,l3;
	struct noeud *v1,*v2,*v3;
	char *nom;
	int rank;
};

struct nom {
	double x,y;
	char *nom;
	char disp_option;
};
struct mon_point {
	double x,y;
	int number;
};
struct trait {
	double xd,yd,xf,yf;
};

enum operations {show_tree = 1, depl_racine, permutation, subtree, prune_clade, prune_clade_found};

class tree_panel : public Fl_Widget {
    FL_EXPORT int handle(int);
public:
    FL_EXPORT void draw(void);
    FL_EXPORT tree_panel(int x,int y,int w,int h) :
	Fl_Widget(x,y,w,h,NULL) {
		;
	}
};

typedef struct {
	char *tree_name;
	char *tree_label;
	int notu;
	int totbranches;
	int has_br_length;
	int lost_br_lengths;
	int has_internal;
	int root_num;
	int rooted;
	struct noeud **tabtax;
	struct noeud *racine;
	char **labels;
	struct branche *branches;
	struct nom *noms;
	struct trait *traits;
	struct mon_point *points;
	char *br_length_txt;
	int totnoms;
	int totpoints;
	int tottraits;
	double deltay;
	double tek_dx, tek_dy, tek_ymin;
	int show_bootstrap;
	int need_runtree;
	enum operations choix;
	int *widnames;
	double *profs;
	int long_arbre_parenth; /* long de la chaine decrivant l'arbre lu */
	struct noeud *subtree_center, *subtree_ascend;
	int subtree_notu;
	int plot_br_l;
	double root_br_l;
	int char_height;
	int ascent;
	int font_size;
	int font_family;
	int swap;
	float bootstrap_threshold;
	char *current_tree;
	SEA_VIEW *view;
	Fl_Round_Button *full;
	Fl_Round_Button *swap_button;
	Fl_Round_Button *subtree;
	Fl_Round_Button *new_outgroup;
	Fl_Button *up;
	Fl_Check_Button *l_button;
	Fl_Check_Button *bt_button;
	tree_panel *panel;
	void *fd_unrooted;
	Fl_Scrollbar *scroller;
	Fl_Menu_Button *menu_file, *menu_edit;
	double zoomvalue;
	struct noeud *prune_clade_node;
	int colored_names_1, colored_traits_1, colored_names_2, colored_traits_2;
	int edit_shape_rank;
	int center_rank;
	Fl_Button *select_clade_button, *delete_clade_button, *complete_edit_button;
	Fl_Counter *zoom;
	Fl_Choice *root_unroot;
	int page_count;
} FD_nj_plot;
#endif
