// File:	StepToGeom_MakeEllipse.cxx
// Created:	Thu Sep  1 13:48:41 1994
// Author:	Frederic MAUPAS
//		<fma@minox>
//:o9 abv 19.02.99: bm4_id_punch_b.stp #678: treatment of ellipse with minR > maxR
//                  NOTE: parametrisation of resulting ellipse shifted on pi/2

#include <StepToGeom_MakeEllipse.ixx>
#include <StepGeom_Ellipse.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <Geom_Axis2Placement.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un Ellipse de Geom a partir d' un Ellipse de Step
//=============================================================================

StepToGeom_MakeEllipse::StepToGeom_MakeEllipse
  ( const Handle(StepGeom_Ellipse)& C)
{
  StepGeom_Axis2Placement   AxisSelect;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)    A1;
  gp_Ax2                         A2;
  Standard_Real                  minorR, majorR;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 2) {
    StepToGeom_MakeAxis2Placement
      MkAxis2(Handle(StepGeom_Axis2Placement3d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis2.Value();
    A2 = A1->Ax2();
    majorR  = C->SemiAxis1() * UnitsMethods::LengthFactor(); 
    minorR  = C->SemiAxis2() * UnitsMethods::LengthFactor(); 
    if ( majorR - minorR >= 0. ) { //:o9 abv 19 Feb 99
      theEllipse = new Geom_Ellipse(A2, majorR, minorR);
      done = Standard_True;
    }
    //:o9 abv 19 Feb 99
    else {
      A2.SetXDirection ( A2.XDirection() ^ A2.Direction() );
      theEllipse = new Geom_Ellipse(A2, minorR, majorR);
      done = Standard_True;
    }
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Ellipse) &
      StepToGeom_MakeEllipse::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theEllipse;
}
