// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepBuild_PaveSet_HeaderFile
#define _TopOpeBRepBuild_PaveSet_HeaderFile

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopOpeBRepBuild_ListOfPave_HeaderFile
#include <TopOpeBRepBuild_ListOfPave.hxx>
#endif
#ifndef _TopOpeBRepBuild_ListIteratorOfListOfPave_HeaderFile
#include <TopOpeBRepBuild_ListIteratorOfListOfPave.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopOpeBRepBuild_LoopSet_HeaderFile
#include <TopOpeBRepBuild_LoopSet.hxx>
#endif
#ifndef _Handle_TopOpeBRepBuild_Pave_HeaderFile
#include <Handle_TopOpeBRepBuild_Pave.hxx>
#endif
#ifndef _Handle_TopOpeBRepBuild_Loop_HeaderFile
#include <Handle_TopOpeBRepBuild_Loop.hxx>
#endif
class TopoDS_Shape;
class TopOpeBRepBuild_Pave;
class TopOpeBRepBuild_Loop;
class TopoDS_Edge;
class TopOpeBRepBuild_ListOfPave;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! class providing an exploration of a set of vertices to build edges. <br>
//! It is similar to LoopSet from TopOpeBRepBuild where Loop is Pave. <br>
class TopOpeBRepBuild_PaveSet  : public TopOpeBRepBuild_LoopSet {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Create a Pave set on edge <E>. It contains <E> vertices. <br>
Standard_EXPORT TopOpeBRepBuild_PaveSet(const TopoDS_Shape& E);


Standard_EXPORT   void RemovePV(const Standard_Boolean B) ;

//! Add <PV> in the Pave set. <br>
Standard_EXPORT   void Append(const Handle(TopOpeBRepBuild_Pave)& PV) ;


Standard_EXPORT virtual  void InitLoop() ;


Standard_EXPORT virtual  Standard_Boolean MoreLoop() const;


Standard_EXPORT virtual  void NextLoop() ;


Standard_EXPORT virtual const Handle_TopOpeBRepBuild_Loop& Loop() const;


Standard_EXPORT  const TopoDS_Edge& Edge() const;


Standard_EXPORT   Standard_Boolean HasEqualParameters() ;


Standard_EXPORT   Standard_Real EqualParameters() const;


Standard_EXPORT   Standard_Boolean ClosedVertices() ;


Standard_EXPORT static  void SortPave(const TopOpeBRepBuild_ListOfPave& Lin,TopOpeBRepBuild_ListOfPave& Lout) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Prepare() ;


 // Fields PRIVATE
 //
TopoDS_Edge myEdge;
TopOpeBRepBuild_ListOfPave myVertices;
TopOpeBRepBuild_ListIteratorOfListOfPave myVerticesIt;
Standard_Integer myEdgeVertexIndex;
Standard_Integer myEdgeVertexCount;
Standard_Boolean myHasEqualParameters;
Standard_Real myEqualParameters;
Standard_Boolean myClosed;
Standard_Boolean myPrepareDone;
Standard_Boolean myRemovePV;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
