// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Directory_HeaderFile
#define _OSD_Directory_HeaderFile

#ifndef _OSD_FileNode_HeaderFile
#include <OSD_FileNode.hxx>
#endif
class OSD_Path;
class OSD_Protection;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Management of directories <br>
class OSD_Directory  : public OSD_FileNode {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates Directory object. <br>
//!          It is initiliazed to an empty name. <br>
Standard_EXPORT OSD_Directory();

//! Creates Directory object initialized with Name. <br>
Standard_EXPORT OSD_Directory(const OSD_Path& Name);

//! Creates (physically) a directory. <br>
//!          When a directory of the same name already exists, no error is <br>
//!          returned, and only <Protect> is applied to the existing directory. <br>
Standard_EXPORT   void Build(const OSD_Protection& Protect) ;

//! Creates a temporary Directory in current directory. <br>
//!          This directory is automatically removed when object dies. <br>
Standard_EXPORT static  OSD_Directory BuildTemporary() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
