// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_MsgFile_HeaderFile
#define _Message_MsgFile_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows to load a file(s) with a set of textual <br>
//!          messages defined, and store the messages in the memory. <br>
//!          Each message is identified by the keyword. User can get the <br>
//!          text of the message by its keyword. <br>
class Message_MsgFile  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT Message_MsgFile();

//! Loads the messages from the file given by its filename. <br>
//!          The new loaded messages are added to the previously loaded <br>
//!          ones (if any). If two messages with the same keywords are <br>
//!          encountered, only last message remains. <br>
Standard_EXPORT static  Standard_Integer LoadFile(const Standard_CString filename) ;

//! Loads the messages from the file with name (without extension) <br>
//!          given by environment variable. <br>
//!          Extension of the file name is given separately. If its not <br>
//!          defined, it is taken: <br>
//!          - by default from environment CSF_LANGUAGE, <br>
//!          - if not defined either, as "us". <br>
Standard_EXPORT static  void LoadFromEnv(const Standard_CString envname,const Standard_CString filename,const Standard_CString ext = "") ;

//! Adds the message to the dictionary. Parameter <code> gives <br>
//!          the key of the message, <text> identifies the message itself. <br>
//!          If there already was defined the message identified by the <br>
//!          same keyword, it is replaced with the new one. <br>
Standard_EXPORT static  void AddMsg(const Standard_CString code,const Standard_CString text) ;

//! Gives the text for the message identified by the keyword <br>
//!          <code>. If there are no messages with such keyword defined, <br>
//!          the keyword itself is returned. <br>
Standard_EXPORT static  Standard_CString Msg(const Standard_CString code) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
