// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESAppli_ElementResults_HeaderFile
#define _IGESAppli_ElementResults_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESAppli_ElementResults_HeaderFile
#include <Handle_IGESAppli_ElementResults.hxx>
#endif

#ifndef _Handle_IGESDimen_GeneralNote_HeaderFile
#include <Handle_IGESDimen_GeneralNote.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESAppli_HArray1OfFiniteElement_HeaderFile
#include <Handle_IGESAppli_HArray1OfFiniteElement.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfInteger_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfReal_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfReal.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESAppli_FiniteElement_HeaderFile
#include <Handle_IGESAppli_FiniteElement.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
class IGESDimen_GeneralNote;
class TColStd_HArray1OfInteger;
class IGESAppli_HArray1OfFiniteElement;
class IGESBasic_HArray1OfHArray1OfInteger;
class IGESBasic_HArray1OfHArray1OfReal;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESAppli_FiniteElement;
class TColStd_HArray1OfReal;


//! defines ElementResults, Type <148> <br>
//!          in package IGESAppli <br>
//!          Used to find the results of FEM analysis <br>
class IGESAppli_ElementResults : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESAppli_ElementResults();

//! This method is used to set the fields of the class <br>
//!           ElementResults <br>
//!       - aNote             : GeneralNote Entity describing analysis <br>
//!       - aSubCase          : Analysis Subcase number <br>
//!       - aTime             : Analysis time value <br>
//!       - nbResults         : Number of result values per FEM <br>
//!       - aResRepFlag       : Results Reporting Flag <br>
//!       - allElementIdents  : FEM element number for elements <br>
//!       - allFiniteElems    : FEM element <br>
//!       - allTopTypes       : Element Topology Types <br>
//!       - nbLayers          : Number of layers per result data location <br>
//!       - allDataLayerFlags : Data Layer Flags <br>
//!       - allnbResDataLocs  : Number of result data report locations <br>
//!       - allResDataLocs    : Result Data Report Locations <br>
//!       - allResults        : List of Result data values of FEM analysis <br>
Standard_EXPORT   void Init(const Handle(IGESDimen_GeneralNote)& aNote,const Standard_Integer aSubCase,const Standard_Real aTime,const Standard_Integer nbResults,const Standard_Integer aResRepFlag,const Handle(TColStd_HArray1OfInteger)& allElementIdents,const Handle(IGESAppli_HArray1OfFiniteElement)& allFiniteElems,const Handle(TColStd_HArray1OfInteger)& allTopTypes,const Handle(TColStd_HArray1OfInteger)& nbLayers,const Handle(TColStd_HArray1OfInteger)& allDataLayerFlags,const Handle(TColStd_HArray1OfInteger)& allnbResDataLocs,const Handle(IGESBasic_HArray1OfHArray1OfInteger)& allResDataLocs,const Handle(IGESBasic_HArray1OfHArray1OfReal)& allResults) ;

//! Changes the FormNumber (which indicates Type of Result) <br>
//!           Error if not in range [0-34] <br>
Standard_EXPORT   void SetFormNumber(const Standard_Integer form) ;

//! returns General Note Entity describing analysis case <br>
Standard_EXPORT   Handle_IGESDimen_GeneralNote Note() const;

//! returns analysis Subcase number <br>
Standard_EXPORT   Standard_Integer SubCaseNumber() const;

//! returns analysis time value <br>
Standard_EXPORT   Standard_Real Time() const;

//! returns number of result values per FEM <br>
Standard_EXPORT   Standard_Integer NbResultValues() const;

//! returns Results Reporting Flag <br>
Standard_EXPORT   Standard_Integer ResultReportFlag() const;

//! returns number of FEM elements <br>
Standard_EXPORT   Standard_Integer NbElements() const;

//! returns FEM element number for elements <br>
Standard_EXPORT   Standard_Integer ElementIdentifier(const Standard_Integer Index) const;

//! returns FEM element <br>
Standard_EXPORT   Handle_IGESAppli_FiniteElement Element(const Standard_Integer Index) const;

//! returns element Topology Types <br>
Standard_EXPORT   Standard_Integer ElementTopologyType(const Standard_Integer Index) const;

//! returns number of layers per result data location <br>
Standard_EXPORT   Standard_Integer NbLayers(const Standard_Integer Index) const;

//! returns Data Layer Flags <br>
Standard_EXPORT   Standard_Integer DataLayerFlag(const Standard_Integer Index) const;

//! returns number of result data report locations <br>
Standard_EXPORT   Standard_Integer NbResultDataLocs(const Standard_Integer Index) const;

//! returns Result Data Report Locations <br>
//! UNFINISHED <br>
Standard_EXPORT   Standard_Integer ResultDataLoc(const Standard_Integer NElem,const Standard_Integer NLoc) const;

//! returns total number of results <br>
Standard_EXPORT   Standard_Integer NbResults(const Standard_Integer Index) const;

//! returns Result data value for an Element, given its <br>
//!           order between 1 and <NbResults(NElem)> (direct access) <br>
//!           For a more comprehensive access, see below <br>
Standard_EXPORT   Standard_Real ResultData(const Standard_Integer NElem,const Standard_Integer num) const;

//! Computes, for a given Element <NElem>, the rank of a <br>
//!           individual Result Data, given <NVal>,<NLay>,<NLoc> <br>
Standard_EXPORT   Standard_Integer ResultRank(const Standard_Integer NElem,const Standard_Integer NVal,const Standard_Integer NLay,const Standard_Integer NLoc) const;

//! returns Result data values of FEM analysis, according this <br>
//!           definition : <br>
//!           - <NElem> : n0 of the Element to be considered <br>
//!           - <NVal> : n0 of the Value between 1 and NbResultValues <br>
//!           - <NLay> : n0 of the Layer for this Element <br>
//!           - <NLoc> : n0 of the Data Location for this Element <br>
//!           This gives for each Element, the corresponding rank <br>
//!           computed by ResultRank, in which the leftmost subscript <br>
//!           changes most rapidly <br>
Standard_EXPORT   Standard_Real ResultData(const Standard_Integer NElem,const Standard_Integer NVal,const Standard_Integer NLay,const Standard_Integer NLoc) const;

//! Returns in once the entire list of data for an Element, <br>
//!           addressed as by ResultRank (See above) <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal ResultList(const Standard_Integer NElem) const;
//Standard_EXPORT ~IGESAppli_ElementResults();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESDimen_GeneralNote theNote;
Standard_Integer theSubcaseNumber;
Standard_Real theTime;
Standard_Integer theNbResultValues;
Standard_Integer theResultReportFlag;
Handle_TColStd_HArray1OfInteger theElementIdentifiers;
Handle_IGESAppli_HArray1OfFiniteElement theElements;
Handle_TColStd_HArray1OfInteger theElementTopologyTypes;
Handle_TColStd_HArray1OfInteger theNbLayers;
Handle_TColStd_HArray1OfInteger theDataLayerFlags;
Handle_TColStd_HArray1OfInteger theNbResultDataLocs;
Handle_IGESBasic_HArray1OfHArray1OfInteger theResultDataLocs;
Handle_IGESBasic_HArray1OfHArray1OfReal theResultData;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
