// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_AspectText3d_HeaderFile
#define _Graphic3d_AspectText3d_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectText3d_HeaderFile
#include <Handle_Graphic3d_AspectText3d.hxx>
#endif

#ifndef _Graphic3d_NameOfFont_HeaderFile
#include <Graphic3d_NameOfFont.hxx>
#endif
#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Aspect_TypeOfStyleText_HeaderFile
#include <Aspect_TypeOfStyleText.hxx>
#endif
#ifndef _Aspect_TypeOfDisplayText_HeaderFile
#include <Aspect_TypeOfDisplayText.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
class Graphic3d_AspectTextDefinitionError;
class Quantity_Color;


//! Creates and updates a group of attributes for <br>
//! 	    text primitives. This group contains the colour, <br>
//!	    font, expansion factor (height/width ratio), and <br>
//!	    inter-character space. <br>
class Graphic3d_AspectText3d : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a context table for text primitives <br>
//!	    defined with the following default values: <br>
Standard_EXPORT Graphic3d_AspectText3d();

//! Creates a context table for text primitives <br>
//!	    defined with the specified values. <br>
Standard_EXPORT Graphic3d_AspectText3d(const Quantity_Color& AColor,const Graphic3d_NameOfFont AFont,const Standard_Real AExpansionFactor,const Standard_Real ASpace,const Aspect_TypeOfStyleText AStyle = Aspect_TOST_NORMAL,const Aspect_TypeOfDisplayText ADisplayType = Aspect_TODT_NORMAL);

//! Modifies the colour of <me>. <br>
Standard_EXPORT   void SetColor(const Quantity_Color& AColor) ;

//! Modifies the expansion factor (height/width ratio) <br>
//!  If the factor is less than 1, the characters will <br>
//!  be higher than they are wide. <br>
Standard_EXPORT   void SetExpansionFactor(const Standard_Real AFactor) ;

//! Modifies the font of <me>. <br>
Standard_EXPORT   void SetFont(const Graphic3d_NameOfFont AFont) ;

//! Modifies the space between the characters. <br>
Standard_EXPORT   void SetSpace(const Standard_Real ASpace) ;

//! Modifies the style of the text. <br>
//!	    TOST_NORMAL		Default text. The text is displayed like any other graphic object. <br>
//!				This text can be hidden by another object that is nearest from the <br>
//!				point of view. <br>
//!	    TOST_ANNOTATION	The text is always visible. The texte is displayed <br>
//!				over the other object according to the priority. <br>
Standard_EXPORT   void SetStyle(const Aspect_TypeOfStyleText AStyle) ;

//! Define the display type of the text. <br>
Standard_EXPORT   void SetDisplayType(const Aspect_TypeOfDisplayText ADisplayType) ;

//! Modifies the colour of the subtitle for the TODT_SUBTITLE TextDisplayType <br>
//! 	    and the colour of backgroubd for the TODT_DEKALE TextDisplayType. <br>
Standard_EXPORT   void SetColorSubTitle(const Quantity_Color& AColor) ;

//! Enable to use the texture mapped fonts by default <br>
Standard_EXPORT static  void TexFontEnable() ;

//! Disable to use the texture mapped fonts by default <br>
Standard_EXPORT static  void TexFontDisable() ;

//! Returns TRUE when the texture mapped fonts are enable to use by default. <br>
Standard_EXPORT static  Standard_Boolean IsTexFontEnable() ;

//! Turns usage of texture mapped fonts on/off <br>
Standard_EXPORT   void SetTextureMappedFont(const Standard_Boolean AFlag) ;

//! Returns the current values of the group <me>. <br>
Standard_EXPORT   void Values(Quantity_Color& AColor,Graphic3d_NameOfFont& AFont,Standard_Real& AnExpansionFactor,Standard_Real& ASpace) const;

//! Returns the current values of the group <me>. <br>
Standard_EXPORT   void Values(Quantity_Color& AColor,Graphic3d_NameOfFont& AFont,Standard_Real& AnExpansionFactor,Standard_Real& ASpace,Aspect_TypeOfStyleText& AStyle,Aspect_TypeOfDisplayText& ADisplayType,Quantity_Color& AColorSubTitle,Standard_Boolean& ATextureMappedFont) const;
//Standard_EXPORT ~Graphic3d_AspectText3d();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Graphic3d_NameOfFont MyFont;
Quantity_Color MyColor;
Standard_Real MyFactor;
Standard_Real MySpace;
Aspect_TypeOfStyleText MyStyle;
Aspect_TypeOfDisplayText MyDisplayType;
Quantity_Color MyColorSubTitle;
Standard_Boolean MyTextureMappedFont;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
