/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import XMLConsumer.IEntry;
import hhapplet.BlockContainer;
import hhapplet.Language;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

class RealItemBlock {
    private Vector m_block;
    private int m_nTop;
    private int m_nNum;
    private String m_sFirstKey;
    private String m_sLastKey;
    private int m_nWidth;
    private boolean m_bNeedCalWidth;

    public int getNum() {
        return this.m_nNum;
    }

    public RealItemBlock(int n, BlockContainer blockContainer) {
        this.m_block = blockContainer.getBlock();
        this.m_sFirstKey = blockContainer.getFirstKey();
        this.m_sLastKey = blockContainer.getLastKey();
        this.m_nTop = n;
        this.m_nNum = this.m_block.size();
        this.m_bNeedCalWidth = true;
    }

    public IEntry getEntry(int n) {
        int n2 = n - this.m_nTop;
        if (n2 < 0 || n2 >= this.m_nNum) {
            return null;
        }
        return (IEntry)this.m_block.elementAt(n2);
    }

    public int getTop() {
        return this.m_nTop;
    }

    public void posChange(int n) {
        this.m_nTop += n;
    }

    protected int calWidth(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_block.size()) {
            IEntry iEntry = (IEntry)this.m_block.elementAt(n3);
            n2 = iEntry.getWidth(graphics);
            if (n2 > n) {
                n = n2;
            }
            ++n3;
        }
        return n;
    }

    public int getClosestEntryId(String string) {
        IEntry iEntry;
        if (Language.compare(this.m_sFirstKey, string) > 0) {
            return -1;
        }
        if (Language.compare(this.m_sLastKey, string) < 0) {
            return this.m_nNum;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (Language.compare((iEntry = (IEntry)this.m_block.elementAt(n3)).getName(), string) < 0 || !iEntry.isMainEntry()) {
            n2 = n3;
            if ((n3 += iEntry.getNextSpan() + 1) < this.m_block.size()) continue;
        }
        n = Language.compare(iEntry.getName(), string) == 0 ? n3 : (iEntry.getName().length() > string.length() && Language.compare(iEntry.getName().substring(0, string.length()), string) == 0 ? n3 : n2);
        return n;
    }

    public String getLastKey() {
        return this.m_sLastKey;
    }

    public void display(Graphics graphics, int n, int n2, int n3, Color color, Image image) {
        int n4 = n - this.m_nTop;
        int n5 = n4 > 0 ? n4 : 0;
        int n6 = n2 + n4 < this.m_nNum ? n2 + n4 : this.m_nNum;
        int n7 = n5;
        while (n7 < n6) {
            IEntry iEntry = (IEntry)this.m_block.elementAt(n7);
            iEntry.display(graphics, n7 - n4, n3, color, image);
            ++n7;
        }
    }

    public String getFirstKey() {
        return this.m_sFirstKey;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_bNeedCalWidth) {
            this.m_nWidth = this.calWidth(graphics);
            this.m_bNeedCalWidth = false;
        }
        return this.m_nWidth;
    }
}

