/***************************************************************************
 *  The FreeMedForms project is a set of free, open source medical         *
 *  applications.                                                          *
 *  (C) 2008-2011 by Eric MAEKER, MD (France) <eric.maeker@gmail.com>      *
 *  All rights reserved.                                                   *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program (COPYING.FREEMEDFORMS file).                   *
 *  If not, see <http://www.gnu.org/licenses/>.                            *
 ***************************************************************************/
/***************************************************************************
 *   Main Developper : Eric MAEKER, <eric.maeker@gmail.com>                *
 *   Contributors :                                                        *
 *       NAME <MAIL@ADRESS>                                                *
 *       NAME <MAIL@ADRESS>                                                *
 ***************************************************************************/
#ifndef DAILYSCHEMEVIEWER_H
#define DAILYSCHEMEVIEWER_H

#include <QtGui/QWidget>
#include <QObject>

/**
 * \file dailyschemeviewer.h
 * \author Eric MAEKER <eric.maeker@gmail.com>
 * \version 0.2.0
 * \date 05 dec 2009
*/


namespace Utils {
class SpinBoxDelegate;
}

namespace DrugsDB {
class DailySchemeModel;
}

namespace DrugsWidget {
namespace Internal {
class DailySchemeViewerPrivate;

class DailySchemeViewer : public QWidget
{
    Q_OBJECT
    /**
      \todo Add properties for the mapper ?
      \todo Add a undo/redo possibility (when changing the view mode)
    */

public:
    DailySchemeViewer(QWidget *parent = 0);
    ~DailySchemeViewer();

    void setModel(DrugsDB::DailySchemeModel *model);
    DrugsDB::DailySchemeModel *model() const;

    void setScoredTablet(bool isScored);
    void setDailyMaximum(double maximum);

protected:
    void changeEvent(QEvent *e);

private:
    DailySchemeViewerPrivate *d;
};


}  // end namespace Internal
}  // End namespace DrugsWidget


#endif // DAILYSCHEMEVIEWER_H
