# $Id: BreadCrumbs.pm,v 1.5 2011-01-31 14:11:33 sb23 Exp $

package EnsEMBL::Web::Document::Element::BreadCrumbs;

### Package to generate breadcrumb links

use strict;

use HTML::Entities qw(encode_entities);

use base qw(EnsEMBL::Web::Document::Element); 

sub init {
  my ($self, $controller) = @_;
  $self->title($controller->content =~ /<title>(.*?)<\/title>/sm ? $1 : 'Untitled: ' . $controller->r->uri) if $controller->request eq 'ssi';
}

sub title {
  my $self = shift;
  $self->{'title'} = shift if @_;
  return $self->{'title'};
}

sub content {
  my $self        = shift;
  my $home        = $self->species_defs->ENSEMBL_BASE_URL;
  my $tree        = $self->species_defs->STATIC_INFO;
  (my $pathstring = $ENV{'SCRIPT_NAME'}) =~ s/^\///; ## Remove leading slash
  my @path        = split '/', $pathstring;
  my @breadcrumbs = qq{<a class="home" href="$home">Home</a>};

  if ($path[0] eq 'info') {
    ## Recurse into tree
    my $current_path = '/info/';
    my $subtree      = $tree->{$path[1]};
    
    ## Top level link
    if ($path[1] eq 'index.html') {
      push @breadcrumbs, encode_entities($tree->{'_title'});
    } else {
      push @breadcrumbs, sprintf '<a href="%s">%s</a>', $current_path, encode_entities($tree->{'_title'});
    }

    for (my $i = 1; $i < scalar @path; $i++) {
      $current_path .= $path[$i];
      $current_path .= '/' if $path[$i] !~ /html$/;
      
      my $next = $self->create_link($subtree, $path[$i+1], $current_path);
      $subtree = $next->{'subtree'};
      
      push @breadcrumbs, $next->{'link'} if $next->{'link'};
    }

    my $last = pop @breadcrumbs;
    my $html = '<ul class="breadcrumbs print_hide">';
    $html   .= join '', map "<li>$_</li>", @breadcrumbs;
    $html   .= qq{<li class="last">$last</li></ul>};
    
    return $html;  
  }
}

sub create_link {
  my ($self, $subtree, $child, $path) = @_;
  my $title = $subtree->{'_title'};
  my $url   = $subtree->{'_path'};
  my ($link, $childtree);
  
  if ($child) {
    $link      = $path =~ /\.html/ ? $title : qq{<a href="$path" title="$title">$title</a>} if $subtree->{'_show'} eq 'y';
    $childtree = $subtree->{$child};
  } else {
    $link = $title;
  }

  return { link => $link, subtree => $childtree };
}

1;
