package EnsEMBL::Web::Component::Help::Results;

use strict;
use warnings;
no warnings "uninitialized";

use EnsEMBL::Web::DBSQL::WebsiteAdaptor;

use base qw(EnsEMBL::Web::Component::Help);

sub _init {
  my $self = shift;
  $self->cacheable( 0 );
  $self->ajaxable(  0 );
  $self->configurable( 0 );
}

sub content {
  my $self = shift;
  my $hub = $self->hub;

  my $html = qq(<h2>Search Results</h2>);
  my @results = $hub->param('result');

  if (scalar(@results) && $results[0]) {

    my %header = (
      'faq'       =>  'Frequently Asked Questions',
      'glossary'  =>  'Glossary',
      'movie'     =>  'Video Tutorials',
      'view'      =>  'Page Help',
    );

    my $adaptor = EnsEMBL::Web::DBSQL::WebsiteAdaptor->new($self->hub);
    my @records = @{$adaptor->fetch_help_by_ids(\@results)};

    ## Now display results
    my ($title, $text); 
    my $prev_type = '';
    foreach my $help (@records) {
      if ($help->{'type'} ne $prev_type) {
        $html .= '<h3>'.$header{$help->{'type'}}."</h3>\n";
      }

      if ($help->{'type'} eq 'faq') {
        $title  = '<h4><strong>'.$help->{'question'}.'</strong></h4>';
        $text   = $help->{'answer'};
        unless ($text =~ /$</) {
          $text = '<p class="space-below">'.$text.'</p>';
        }
        ## Add feedback form
        $text .= $self->help_feedback('text-align:right;margin-right:2em', $help->{'id'}, return_url => '/Help/Results', type => $help->{'type'});
      }
      elsif ($help->{'type'} eq 'glossary') {
        $title  = '<p class="space-below"><strong>'.$help->{'word'}.'</strong>: ';
        $text   = $help->{'meaning'}.'</p>';
      }
      elsif ($help->{'type'} eq 'view') {
        $title = '<h4>'.$help->{'ensembl_object'}.'/'.$help->{'ensembl_action'}.'</h4>';
        ## These entries can be quite long - strip the HTML and show just a short section
        (my $content = $help->{'content'}) =~ s/<[^>]*>//gs;
        $text = substr($content, 0, 500);
        $text .= ' <a href="/Help/View?id='.$help->{'id'}.'">More...</a>';
      }
      elsif ($help->{'type'} eq 'movie') {
        $title  = '<p class="space-below"><strong><a href="/Help/Movie?id='.$help->{'id'}.'" class="popup">'.$help->{'title'}.'</a></strong></p>';
      }
      if ($hub->param('hilite') eq 'yes') {
        $title  = $self->kw_hilite($title);
        $text   = $self->kw_hilite($text);
      }

      $html .= qq($title\n$text); 


      $prev_type = $help->{'type'};
    }
  } 
  else {
    $html = qq(<p>Sorry, no results were found in the help database matching your query.</p>
<ul>
<li><a href="/Help/Search" class="popup">Search again</a></li>
<li><a href="/info/" class="cp-external">Browse non-searchable pages</a></li>
</ul>);
  }

  return $html;
}

1;
